/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TriBool;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7498")
public class EmptyCollectionConstructorCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Replace this constructor call with a literal.";
    private static final Map<String, String> COLLECTION_CONSTRUCTORS = Map.ofEntries(Map.entry("list", "[]"), Map.entry("tuple", "()"), Map.entry("dict", "{}"));
    private TypeCheckMap<String> collectionConstructorTypeCheckers = null;
    private TypeCheckBuilder dictChecker = null;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.dictChecker = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("dict");
            this.collectionConstructorTypeCheckers = new TypeCheckMap();
            for (Map.Entry<String, String> constructorEntry : COLLECTION_CONSTRUCTORS.entrySet()) {
                TypeCheckBuilder constructorTypeChecker = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn(constructorEntry.getKey());
                this.collectionConstructorTypeCheckers.put(constructorTypeChecker, (Object)constructorEntry.getValue());
            }
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, ctx -> {
            CallExpression callExpression = (CallExpression)ctx.syntaxNode();
            if (this.isUnnecessaryCollectionConstructor(callExpression)) {
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)callExpression.callee(), MESSAGE);
                this.createQuickFix(callExpression).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0));
            }
        });
    }

    private boolean isUnnecessaryCollectionConstructor(CallExpression callExpression) {
        return this.isCollectionConstructor(callExpression.callee()) && EmptyCollectionConstructorCheck.isEmptyCall(callExpression) || this.isDictConstructorWithOnlyMappings(callExpression);
    }

    private boolean isCollectionConstructor(Expression calleeExpression) {
        PythonType type = calleeExpression.typeV2();
        return this.collectionConstructorTypeCheckers.getOptionalForType(type).isPresent() && !(calleeExpression instanceof SubscriptionExpression);
    }

    private static boolean isEmptyCall(CallExpression callExpression) {
        return callExpression.arguments().isEmpty();
    }

    private boolean isDictConstructorWithOnlyMappings(CallExpression callExpression) {
        return this.isDictConstructor(callExpression) && EmptyCollectionConstructorCheck.hasOnlyKeywordArguments(callExpression);
    }

    private boolean isDictConstructor(CallExpression callExpression) {
        return this.dictChecker.check(callExpression.callee().typeV2()) == TriBool.TRUE;
    }

    private static boolean hasOnlyKeywordArguments(CallExpression callExpression) {
        return callExpression.arguments().stream().allMatch(EmptyCollectionConstructorCheck::isKeywordArg);
    }

    private static boolean isKeywordArg(Argument arg) {
        RegularArgument regularArg;
        return arg instanceof RegularArgument && (regularArg = (RegularArgument)arg).keywordArgument() != null;
    }

    private Optional<PythonQuickFix> createQuickFix(CallExpression callExpression) {
        return Optional.of(callExpression).filter(EmptyCollectionConstructorCheck::isEmptyCall).flatMap(callExpr -> this.collectionConstructorTypeCheckers.getOptionalForType(callExpression.callee().typeV2())).map(replacementStr -> PythonQuickFix.newQuickFix((String)"Replace with literal", (PythonTextEdit[])new PythonTextEdit[]{TextEditUtils.replace((Tree)callExpression, (String)replacementStr)}));
    }
}

