/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TriBool;

@Rule(key="S5707")
public class ExceptionCauseTypeCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.RAISE_STMT, ctx -> {
            RaiseStatement raise = (RaiseStatement)ctx.syntaxNode();
            ExceptionCauseTypeCheck.check(raise.fromExpression(), ctx);
        });
        context.registerSyntaxNodeConsumer(Tree.Kind.ASSIGNMENT_STMT, ctx -> {
            AssignmentStatement assignment = (AssignmentStatement)ctx.syntaxNode();
            Stream lhsExpressions = assignment.lhsExpressions().stream().flatMap(list -> list.expressions().stream());
            if (lhsExpressions.anyMatch(ExceptionCauseTypeCheck::isAccessToCause)) {
                ExceptionCauseTypeCheck.check(assignment.assignedValue(), ctx);
            }
        });
    }

    private static boolean isAccessToCause(Expression e) {
        return e.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR}) && "__cause__".equals(((QualifiedExpression)e).name().name());
    }

    private static void check(@Nullable Expression cause, SubscriptionContext ctx) {
        if (cause == null) {
            return;
        }
        PythonType causeType = cause.typeV2();
        TriBool inheritsFromBaseException = ctx.typeChecker().typeCheckBuilder().isInstanceOf("BaseException").check(causeType);
        TriBool isNoneType = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("NoneType").check(causeType);
        if (inheritsFromBaseException == TriBool.FALSE && isNoneType == TriBool.FALSE) {
            ctx.addIssue((Tree)cause, "Replace this expression with an exception or None");
        }
    }
}

