/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.cdk.AbstractIamPolicyStatementCheck;
import org.sonar.python.checks.cdk.CdkPredicate;
import org.sonar.python.checks.cdk.CdkUtils;
import org.sonar.python.checks.cdk.PolicyStatement;

@Rule(key="S6302")
public class PrivilegePolicyCheck
extends AbstractIamPolicyStatementCheck {
    private static final String MESSAGE = "Make sure granting all privileges is safe here.";
    private static final String SECONDARY_MESSAGE = "Related effect";

    @Override
    protected void checkAllowingPolicyStatement(PolicyStatement policyStatement) {
        CdkUtils.ExpressionFlow action = policyStatement.actions();
        if (action == null) {
            return;
        }
        Optional.ofNullable(PrivilegePolicyCheck.getSensitiveExpression(action, CdkPredicate.isWildcard())).ifPresent(wildcard -> PrivilegePolicyCheck.reportWildcardActionAndEffect(wildcard, policyStatement.effect()));
    }

    private static void reportWildcardActionAndEffect(CdkUtils.ExpressionFlow wildcard, @Nullable CdkUtils.ExpressionFlow effect) {
        PythonCheck.PreciseIssue issue = wildcard.ctx().addIssue((Tree)wildcard.getLast(), MESSAGE);
        if (effect != null) {
            issue.secondary(effect.asSecondaryLocation(SECONDARY_MESSAGE));
        }
    }
}

