/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.Argument;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.checks.utils.GraphQLUtils;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S6786")
public class GraphQLIntrospectionCheck
extends PythonSubscriptionCheck {
    private static final Set<String> SAFE_VALIDATION_RULE_FQNS = Set.of("graphene.validation.DisableIntrospection", "graphql.validation.NoSchemaIntrospectionCustomRule");
    private static final String MESSAGE = "Disable introspection on this \"GraphQL\" server endpoint.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, GraphQLIntrospectionCheck::checkGraphQLIntrospection);
    }

    private static void checkGraphQLIntrospection(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Optional.of(callExpression).map(CallExpression::callee).flatMap(TreeUtils.toOptionalInstanceOfMapper(QualifiedExpression.class)).filter(GraphQLUtils::isCallToAsView).map(QualifiedExpression::qualifier).filter(HasSymbol.class::isInstance).map(HasSymbol.class::cast).map(HasSymbol::symbol).filter(GraphQLUtils::isOrExtendsGraphQLView).filter(fqn -> !GraphQLIntrospectionCheck.hasSafeMiddlewares(callExpression.arguments())).filter(fqn -> !GraphQLIntrospectionCheck.hasSafeValidationRules(callExpression.arguments())).ifPresent(fqn -> ctx.addIssue((Tree)callExpression.callee(), MESSAGE));
    }

    private static boolean hasSafeMiddlewares(List<Argument> arguments) {
        RegularArgument argument = TreeUtils.argumentByKeyword((String)"middleware", arguments);
        if (argument == null) {
            return false;
        }
        Optional<Expression> argumentValue = Expressions.ifNameGetSingleAssignedNonNameValue(argument.expression());
        boolean isNotTupleNorListLiteral = argumentValue.filter(a -> a.is(new Tree.Kind[]{Tree.Kind.LIST_LITERAL, Tree.Kind.TUPLE})).isEmpty();
        return isNotTupleNorListLiteral || Expressions.expressionsFromListOrTuple(argumentValue.get()).stream().anyMatch(GraphQLIntrospectionCheck::isSafeMiddlewareName);
    }

    private static boolean hasSafeValidationRules(List<Argument> arguments) {
        RegularArgument argument = TreeUtils.argumentByKeyword((String)"validation_rules", arguments);
        if (argument == null) {
            return false;
        }
        Optional<Expression> argumentValue = Expressions.ifNameGetSingleAssignedNonNameValue(argument.expression());
        boolean isNotTupleNorListLiteral = argumentValue.filter(a -> a.is(new Tree.Kind[]{Tree.Kind.LIST_LITERAL, Tree.Kind.TUPLE})).isEmpty();
        return isNotTupleNorListLiteral || Expressions.expressionsFromListOrTuple(argumentValue.get()).stream().anyMatch(GraphQLIntrospectionCheck::isSafeValidationRule);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSafeValidationRule(Expression value) {
        if (GraphQLIntrospectionCheck.isSafeMiddlewareName(value)) return true;
        if (!GraphQLUtils.expressionFQNMatchPredicate(value, SAFE_VALIDATION_RULE_FQNS::contains)) return false;
        return true;
    }

    private static boolean isSafeMiddlewareName(Expression value) {
        return GraphQLUtils.expressionTypeOrNameMatchPredicate(value, name -> name.toUpperCase(Locale.ROOT).contains("INTROSPECTION"));
    }
}

