/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.hotspots;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TriBool;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.semantic.v2.UsageV2;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S5527")
public class UnverifiedHostnameCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Enable server hostname verification on this SSL/TLS connection.";
    private static final String SECONDARY_OPENSSL = "This context does not perform hostname verification.";
    private static final String SECONDARY_DISABLED = "Hostname verification is disabled here.";
    private static final Set<String> SECURE_BY_DEFAULT = new HashSet<String>(Arrays.asList("ssl.create_default_context", "ssl._create_default_https_context"));
    private static final Set<String> UNSECURE_BY_DEFAULT = new HashSet<String>(Arrays.asList("ssl._create_unverified_context", "ssl._create_stdlib_context"));
    private static final Set<String> UNSAFE_PROTOCOLS = Set.of("ssl.PROTOCOL_SSLv23", "ssl.PROTOCOL_TLS", "ssl.PROTOCOL_SSLv3", "ssl.PROTOCOL_TLSv1", "ssl.PROTOCOL_TLSv1_1", "ssl.PROTOCOL_TLSv1_2");
    private static Set<String> functionsToCheck;
    private TypeCheckBuilder openSSLConnectionTypeCheckBuilder;
    private TypeCheckBuilder openSSLContextTypeCheckBuilder;
    private TypeCheckBuilder sslContextTypeCheckBuilder;

    private static Set<String> functionsToCheck() {
        if (functionsToCheck == null) {
            functionsToCheck = new HashSet<String>();
            functionsToCheck.addAll(SECURE_BY_DEFAULT);
            functionsToCheck.addAll(UNSECURE_BY_DEFAULT);
        }
        return Collections.unmodifiableSet(functionsToCheck);
    }

    private static void checkSuspiciousCall(CallExpression callExpression, Symbol calleeSymbol, SubscriptionContext ctx) {
        Tree parent = TreeUtils.firstAncestorOfKind((Tree)callExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT, Tree.Kind.CALL_EXPR});
        if (parent == null) {
            return;
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})) {
            Expression lhs = (Expression)((ExpressionList)((AssignmentStatement)parent).lhsExpressions().get(0)).expressions().get(0);
            if (lhs instanceof HasSymbol) {
                HasSymbol hasSymbol = (HasSymbol)lhs;
                Symbol symbol = hasSymbol.symbol();
                if (symbol == null) {
                    return;
                }
                if (UnverifiedHostnameCheck.isUnsafeContext(calleeSymbol, symbol)) {
                    ctx.addIssue((Tree)callExpression, MESSAGE);
                }
            }
        } else if (UnverifiedHostnameCheck.opensUnsecureConnection(calleeSymbol, (CallExpression)parent)) {
            ctx.addIssue((Tree)callExpression, MESSAGE);
        }
    }

    private static boolean isUnsafeContext(Symbol calleeSymbol, Symbol symbol) {
        for (Usage usage : symbol.usages()) {
            AssignmentStatement assignmentStatement;
            QualifiedExpression qualifiedExpression;
            if (!usage.kind().equals((Object)Usage.Kind.OTHER) || (qualifiedExpression = (QualifiedExpression)TreeUtils.firstAncestorOfKind((Tree)usage.tree(), (Tree.Kind[])new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) == null || !"check_hostname".equals(qualifiedExpression.name().name()) || (assignmentStatement = (AssignmentStatement)TreeUtils.firstAncestorOfKind((Tree)qualifiedExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})) == null) continue;
            return Expressions.isFalsy(assignmentStatement.assignedValue());
        }
        return UNSECURE_BY_DEFAULT.contains(calleeSymbol.fullyQualifiedName());
    }

    private static boolean opensUnsecureConnection(Symbol calleeSymbol, CallExpression callExpr) {
        Symbol parentCalleeSymbol = callExpr.calleeSymbol();
        return parentCalleeSymbol != null && "urllib.request.urlopen".equals(parentCalleeSymbol.fullyQualifiedName()) && UNSECURE_BY_DEFAULT.contains(calleeSymbol.fullyQualifiedName());
    }

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkCallExpression);
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.openSSLConnectionTypeCheckBuilder = ctx.typeChecker().typeCheckBuilder().isTypeWithName("OpenSSL.SSL.Connection");
            this.openSSLContextTypeCheckBuilder = ctx.typeChecker().typeCheckBuilder().isInstanceOf("OpenSSL.SSL.Context");
            this.sslContextTypeCheckBuilder = ctx.typeChecker().typeCheckBuilder().isTypeWithName("ssl.SSLContext");
        });
    }

    private void checkCallExpression(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Symbol calleeSymbol = callExpression.calleeSymbol();
        if (calleeSymbol != null && UnverifiedHostnameCheck.functionsToCheck().contains(calleeSymbol.fullyQualifiedName())) {
            UnverifiedHostnameCheck.checkSuspiciousCall(callExpression, calleeSymbol, ctx);
        }
        this.checkOpenSSLConnection(ctx, callExpression);
        this.checkSSLContext(ctx, callExpression);
    }

    private void checkSSLContext(SubscriptionContext ctx, CallExpression callExpression) {
        Expression callee = callExpression.callee();
        PythonType pythonType = callee.typeV2();
        if (this.sslContextTypeCheckBuilder.check(pythonType) != TriBool.TRUE) {
            return;
        }
        Optional<Symbol> protocolSymbolOpt = UnverifiedHostnameCheck.getProtocolSymbol(callExpression);
        if (protocolSymbolOpt.isEmpty()) {
            return;
        }
        Symbol protocolSymbol = protocolSymbolOpt.get();
        String protocolFQN = protocolSymbol.fullyQualifiedName();
        if (protocolFQN == null) {
            return;
        }
        Tree parent = TreeUtils.firstAncestorOfKind((Tree)callExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT});
        if (parent == null) {
            if (UNSAFE_PROTOCOLS.contains(protocolFQN)) {
                ctx.addIssue((Tree)callExpression, MESSAGE);
            }
            return;
        }
        Optional<SymbolV2> contextSymbol = UnverifiedHostnameCheck.getContextSymbol((AssignmentStatement)parent);
        if (contextSymbol.isEmpty()) {
            return;
        }
        if (UNSAFE_PROTOCOLS.contains(protocolFQN)) {
            Optional<AssignmentStatement> hostnameEnabledAssignment = UnverifiedHostnameCheck.findCheckHostnameStatement(contextSymbol.get(), Expressions::isTruthy);
            if (hostnameEnabledAssignment.isEmpty()) {
                ctx.addIssue((Tree)callExpression, MESSAGE);
            }
        } else {
            Optional<AssignmentStatement> hostnameDisabledAssignment = UnverifiedHostnameCheck.findCheckHostnameStatement(contextSymbol.get(), Expressions::isFalsy);
            hostnameDisabledAssignment.ifPresent(assignment -> {
                PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)callee, MESSAGE);
                issue.secondary((Tree)assignment, SECONDARY_DISABLED);
            });
        }
    }

    private static Optional<Symbol> getProtocolSymbol(CallExpression callExpression) {
        return Optional.ofNullable(TreeUtils.nthArgumentOrKeyword((int)0, (String)"protocol", (List)callExpression.arguments())).map(RegularArgument::expression).filter(HasSymbol.class::isInstance).map(expr -> ((HasSymbol)expr).symbol());
    }

    private static Optional<SymbolV2> getContextSymbol(AssignmentStatement assignmentStatement) {
        return Optional.ofNullable((Expression)((ExpressionList)assignmentStatement.lhsExpressions().get(0)).expressions().get(0)).filter(Name.class::isInstance).map(expr -> ((Name)expr).symbolV2());
    }

    private static Optional<AssignmentStatement> findCheckHostnameStatement(SymbolV2 contextSymbol, Predicate<Expression> valueCheck) {
        return contextSymbol.usages().stream().map(UsageV2::tree).map(Tree::parent).filter(QualifiedExpression.class::isInstance).map(QualifiedExpression.class::cast).filter(qe -> "check_hostname".equals(qe.name().name())).map(t -> TreeUtils.firstAncestorOfKind((Tree)t, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.ASSIGNMENT_STMT})).filter(Objects::nonNull).map(AssignmentStatement.class::cast).filter(a -> valueCheck.test(a.assignedValue())).findFirst();
    }

    private void checkOpenSSLConnection(SubscriptionContext ctx, CallExpression callExpression) {
        Expression callee = callExpression.callee();
        PythonType pythonType = callee.typeV2();
        if (this.openSSLConnectionTypeCheckBuilder.check(pythonType) != TriBool.TRUE) {
            return;
        }
        RegularArgument contextArg = TreeUtils.nthArgumentOrKeyword((int)0, (String)"context", (List)callExpression.arguments());
        if (contextArg == null) {
            return;
        }
        Expression contextExpr = contextArg.expression();
        PythonType contextType = contextExpr.typeV2();
        if (this.openSSLContextTypeCheckBuilder.check(contextType) == TriBool.TRUE) {
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)callee, MESSAGE);
            Expressions.ifNameGetSingleAssignedNonNameValue(contextExpr).ifPresentOrElse(e -> issue.secondary((Tree)e, SECONDARY_OPENSSL), () -> issue.secondary((Tree)contextExpr, SECONDARY_OPENSSL));
        }
    }
}

