/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.utils;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.ComprehensionClause;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TriBool;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.types.v2.TypeCheckBuilder;

public class IsComprehensionTransformedChecker {
    private TypeCheckBuilder dictTypeChecker = null;

    public IsComprehensionTransformedChecker(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            this.dictTypeChecker = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("dict");
        });
    }

    public boolean isGeneratorTransformingData(ComprehensionExpression generator, PythonType methodType) {
        if (IsComprehensionTransformedChecker.hasMultipleNestedClauses((ComprehensionClause)generator.comprehensionFor())) {
            return true;
        }
        if (this.dictTypeChecker.check(methodType) == TriBool.TRUE) {
            return IsComprehensionTransformedChecker.isDictTransformingData(generator);
        }
        return IsComprehensionTransformedChecker.isListOrSetComprehensionTransformingData(generator);
    }

    private static boolean hasMultipleNestedClauses(ComprehensionClause clause) {
        return clause.nestedClause() != null;
    }

    private static boolean isDictTransformingData(ComprehensionExpression generator) {
        Expression resultExpr = generator.resultExpression();
        Expression loopVarExpr = generator.comprehensionFor().loopExpression();
        TwoNamedTuple resultTuple = IsComprehensionTransformedChecker.getTwoNamedTuple(resultExpr);
        TwoNamedTuple varTuple = IsComprehensionTransformedChecker.getTwoNamedTuple(loopVarExpr);
        if (resultTuple != null && varTuple != null) {
            return !resultTuple.equals(varTuple);
        }
        return true;
    }

    private static TwoNamedTuple getTwoNamedTuple(Expression expr) {
        List elements;
        Object e;
        Tuple tuple;
        if (expr instanceof Tuple && (tuple = (Tuple)expr).elements().size() == 2 && (e = (elements = tuple.elements()).get(0)) instanceof Name) {
            Name name1 = (Name)e;
            e = elements.get(1);
            if (e instanceof Name) {
                Name name2 = (Name)e;
                return new TwoNamedTuple(name1.symbolV2(), name2.symbolV2());
            }
        }
        return null;
    }

    private static boolean isListOrSetComprehensionTransformingData(ComprehensionExpression generator) {
        Expression elementExpr = generator.resultExpression();
        Expression loopVarExpr = generator.comprehensionFor().loopExpression();
        if (elementExpr instanceof Name) {
            Name elementName = (Name)elementExpr;
            if (loopVarExpr instanceof Name) {
                Name loopVarName = (Name)loopVarExpr;
                return elementName.symbolV2() != loopVarName.symbolV2();
            }
        }
        return true;
    }

    private record TwoNamedTuple(@Nullable SymbolV2 symbol1, @Nullable SymbolV2 symbol2) {
    }
}

