/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonLine;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.TriBool;
import org.sonar.python.cfg.fixpoint.ReachingDefinitionsAnalysis;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeChecker;

@Rule(key="S1244")
public class FloatingPointEqualityCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Do not perform equality checks with floating point values.";
    private static final String QUICK_FIX_MESSAGE = "Replace with \"%s%s.isclose()\".";
    private static final String QUICK_FIX_MATH = "%s%s.isclose(%s, %s, rel_tol=1e-09, abs_tol=1e-09)";
    private static final String QUICK_FIX_IMPORTED_MODULE = "%s%s.isclose(%s, %s, rtol=1e-09, atol=1e-09)";
    private static final Tree.Kind[] BINARY_OPERATION_KINDS = new Tree.Kind[]{Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.MULTIPLICATION, Tree.Kind.DIVISION};
    private static final String MATH_MODULE = "math";
    private ReachingDefinitionsAnalysis reachingDefinitionsAnalysis;
    private static final List<String> SUPPORTED_IS_CLOSE_MODULES = Arrays.asList("numpy", "torch", "math");
    private String importedModuleForIsClose;
    private Name importedAlias;
    private boolean isMathImported = false;
    private TypeChecker typeChecker;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeAnalysis);
        context.registerSyntaxNodeConsumer(Tree.Kind.IMPORT_NAME, ctx -> ((ImportName)ctx.syntaxNode()).modules().forEach(this::addImportedName));
        context.registerSyntaxNodeConsumer(Tree.Kind.COMPARISON, this::checkFloatingPointEquality);
    }

    private void initializeAnalysis(SubscriptionContext ctx) {
        this.reachingDefinitionsAnalysis = new ReachingDefinitionsAnalysis(ctx.pythonFile());
        this.importedModuleForIsClose = null;
        this.importedAlias = null;
        this.typeChecker = ctx.typeChecker();
    }

    private void checkFloatingPointEquality(SubscriptionContext ctx) {
        BinaryExpression binaryExpression = (BinaryExpression)ctx.syntaxNode();
        String operator = binaryExpression.operator().value();
        if (("==".equals(operator) || "!=".equals(operator)) && this.isAnyOperandFloatingPoint(binaryExpression)) {
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)binaryExpression, MESSAGE);
            issue.addQuickFix(this.createQuickFix(binaryExpression, operator));
        }
    }

    private boolean isAnyOperandFloatingPoint(BinaryExpression binaryExpression) {
        Expression leftOperand = binaryExpression.leftOperand();
        Expression rightOperand = binaryExpression.rightOperand();
        return this.isFloat(leftOperand) || this.isFloat(rightOperand) || this.isAssignedFloat(leftOperand) || this.isAssignedFloat(rightOperand) || this.isBinaryOperationWithFloat(leftOperand) || this.isBinaryOperationWithFloat(rightOperand);
    }

    private boolean isFloat(Expression expression) {
        TriBool isTypeFloat = this.typeChecker.typeCheckBuilder().isBuiltinWithName("float").check(expression.typeV2());
        return expression.is(new Tree.Kind[]{Tree.Kind.NUMERIC_LITERAL}) && isTypeFloat == TriBool.TRUE;
    }

    private boolean isAssignedFloat(Expression expression) {
        Set values;
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME}) && !(values = this.reachingDefinitionsAnalysis.valuesAtLocation((Name)expression)).isEmpty()) {
            return values.stream().allMatch(this::isFloat);
        }
        return false;
    }

    private boolean isBinaryOperationWithFloat(Expression expression) {
        if (expression.is(BINARY_OPERATION_KINDS)) {
            return this.isAnyOperandFloatingPoint((BinaryExpression)expression);
        }
        return false;
    }

    private PythonQuickFix createQuickFix(BinaryExpression binaryExpression, String operator) {
        String notToken = "!=".equals(operator) ? "not " : "";
        String isCloseModuleName = this.getModuleNameOrAliasForIsClose();
        String message = String.format(QUICK_FIX_MESSAGE, notToken, isCloseModuleName);
        PythonQuickFix.Builder quickFix = PythonQuickFix.newQuickFix((String)message);
        String quickFixText = MATH_MODULE.equals(isCloseModuleName) ? QUICK_FIX_MATH : QUICK_FIX_IMPORTED_MODULE;
        String quickFixTextWithModuleName = String.format(quickFixText, notToken, isCloseModuleName, TreeUtils.treeToString((Tree)binaryExpression.leftOperand(), (boolean)false), TreeUtils.treeToString((Tree)binaryExpression.rightOperand(), (boolean)false));
        quickFix.addTextEdit(new PythonTextEdit[]{TextEditUtils.replace((Tree)binaryExpression, (String)quickFixTextWithModuleName)});
        if (MATH_MODULE.equals(isCloseModuleName) && !this.isMathImported) {
            quickFix.addTextEdit(new PythonTextEdit[]{TextEditUtils.insertAtPosition((PythonLine)new PythonLine(0), (int)0, (String)"import math\n")});
        }
        return quickFix.build();
    }

    private String getModuleNameOrAliasForIsClose() {
        if (this.importedAlias != null) {
            return this.importedAlias.name();
        }
        if (this.importedModuleForIsClose != null) {
            return this.importedModuleForIsClose;
        }
        return MATH_MODULE;
    }

    private void addImportedName(AliasedName aliasedName) {
        List importNames = aliasedName.dottedName().names();
        if (this.importedModuleForIsClose == null || MATH_MODULE.equals(this.importedModuleForIsClose)) {
            importNames.stream().filter(name -> SUPPORTED_IS_CLOSE_MODULES.contains(name.name())).findFirst().map(Name::name).ifPresent(name -> {
                if (MATH_MODULE.equals(name)) {
                    this.isMathImported = true;
                }
                this.importedModuleForIsClose = name;
                this.importedAlias = aliasedName.alias();
            });
        }
    }
}

