/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.types.v2.TriBool;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.semantic.v2.SymbolV2;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7512")
public class InefficientDictIterationCheck
extends PythonSubscriptionCheck {
    private TypeCheckBuilder dictItemsTypeCheck;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.FOR_STMT, this::check);
    }

    private void initChecks(SubscriptionContext ctx) {
        this.dictItemsTypeCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithName("dict.items");
    }

    private void check(SubscriptionContext ctx) {
        ForStatement forStatement = (ForStatement)ctx.syntaxNode();
        boolean hasIgnoredKey = InefficientDictIterationCheck.hasIgnoredKey(forStatement);
        boolean hasIgnoredValue = InefficientDictIterationCheck.hasIgnoredValue(forStatement);
        if (forStatement.testExpressions().size() == 1 && (hasIgnoredKey || hasIgnoredValue) && (this.isSensitiveMethodCall((Expression)forStatement.testExpressions().get(0)) || this.isAssignedToSensitiveMethodCall((Expression)forStatement.testExpressions().get(0)))) {
            String message = hasIgnoredKey ? "Modify this loop to iterate over the dictionary's values." : "Modify this loop to iterate directly over the dictionary.";
            ctx.addIssue((Tree)forStatement.testExpressions().get(0), message);
        }
    }

    private static boolean hasIgnoredKey(ForStatement forStatement) {
        Name keyName;
        Object e;
        return forStatement.expressions().size() == 2 && (e = forStatement.expressions().get(0)) instanceof Name && "_".equals((keyName = (Name)e).name());
    }

    private static boolean hasIgnoredValue(ForStatement forStatement) {
        Name keyName;
        Object e;
        return forStatement.expressions().size() == 2 && (e = forStatement.expressions().get(1)) instanceof Name && "_".equals((keyName = (Name)e).name());
    }

    private boolean isSensitiveMethodCall(@Nullable Expression expression) {
        CallExpression callExpression;
        return expression instanceof CallExpression && this.dictItemsTypeCheck.check((callExpression = (CallExpression)expression).callee().typeV2()) == TriBool.TRUE;
    }

    private boolean isAssignedToSensitiveMethodCall(Expression argumentExpression) {
        Name name;
        return argumentExpression instanceof Name && InefficientDictIterationCheck.getUsageCount(name = (Name)argumentExpression) == 2 && this.isSensitiveMethodCall(Expressions.singleAssignedValue(name));
    }

    private static int getUsageCount(Name name) {
        return Optional.ofNullable(name.symbolV2()).map(SymbolV2::usages).map(List::size).orElse(0);
    }
}

