/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckMap;

@Rule(key="S7499")
public class SynchronousHttpOperationsInAsyncCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use an async HTTP client in this async function instead of a synchronous one.";
    private static final String SECONDARY_MESSAGE = "This function is async.";
    private static final Set<String> IMPORT_PATHS = Set.of("requests.get", "requests.post", "requests.put", "requests.delete", "requests.head", "requests.options", "requests.patch", "requests.sessions.Session.get", "requests.sessions.Session.post", "requests.sessions.Session.put", "requests.sessions.Session.delete", "requests.sessions.Session.head", "requests.sessions.Session.options", "requests.sessions.Session.patch", "urllib3.PoolManager", "urllib3.PoolManager.request");
    private static final Set<String> IMPORT_PATHS_FQN = Set.of("httpx.get", "httpx.post", "httpx.put", "httpx.delete", "httpx.head", "httpx.options", "httpx.patch");
    private TypeCheckMap<Object> syncHttpTypeChecks;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::setupTypeChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::checkSyncHttpInAsync);
    }

    private void setupTypeChecks(SubscriptionContext ctx) {
        this.syncHttpTypeChecks = new TypeCheckMap();
        Object object = new Object();
        IMPORT_PATHS.forEach(path -> this.syncHttpTypeChecks.put(ctx.typeChecker().typeCheckBuilder().isTypeOrInstanceWithName(path), object));
        IMPORT_PATHS_FQN.forEach(path -> this.syncHttpTypeChecks.put(ctx.typeChecker().typeCheckBuilder().isTypeWithFqn(path), object));
    }

    private void checkSyncHttpInAsync(SubscriptionContext ctx) {
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        Token asyncToken = TreeUtils.asyncTokenOfEnclosingFunction((Tree)callExpression).orElse(null);
        if (asyncToken == null) {
            return;
        }
        this.syncHttpTypeChecks.getOptionalForType(callExpression.callee().typeV2()).ifPresent(object -> ctx.addIssue((Tree)callExpression.callee(), MESSAGE).secondary(asyncToken, SECONDARY_MESSAGE));
    }
}

