/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.AwaitExpression;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.Statement;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.plugins.python.api.tree.YieldExpression;
import org.sonar.plugins.python.api.tree.YieldStatement;
import org.sonar.plugins.python.api.types.v2.ClassType;
import org.sonar.plugins.python.api.types.v2.FunctionType;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.TriBool;
import org.sonar.python.checks.utils.CheckUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7503")
public class AsyncFunctionNotAsyncCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Use asynchronous features in this function or remove the `async` keyword.";
    private TypeCheckBuilder notImplementedTypeChecker;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::setupTypeChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.FUNCDEF, this::checkAsyncFunction);
    }

    private void setupTypeChecks(SubscriptionContext ctx) {
        this.notImplementedTypeChecker = ctx.typeChecker().typeCheckBuilder().isTypeWithName("NotImplemented");
    }

    private void checkAsyncFunction(SubscriptionContext ctx) {
        FunctionDef functionDef = (FunctionDef)ctx.syntaxNode();
        Token asyncKeyword = functionDef.asyncKeyword();
        if (asyncKeyword == null || this.isException(functionDef)) {
            return;
        }
        AsyncFeatureVisitor visitor = new AsyncFeatureVisitor();
        functionDef.body().accept((TreeVisitor)visitor);
        if (!visitor.hasAsyncFeature()) {
            ctx.addIssue((Tree)functionDef.name(), MESSAGE).secondary(asyncKeyword, "This function is async.");
        }
    }

    private boolean isException(FunctionDef functionDef) {
        return CheckUtils.isAbstract(functionDef) || this.isTrivialFunction(functionDef.body()) || AsyncFunctionNotAsyncCheck.isDunderMethod(functionDef) || !functionDef.decorators().isEmpty() || AsyncFunctionNotAsyncCheck.mightBeOverridingMethod(functionDef);
    }

    private static boolean isDunderMethod(FunctionDef functionDef) {
        String methodName = functionDef.name().name();
        return methodName.startsWith("__");
    }

    private boolean isTrivialFunction(StatementList body) {
        for (Statement statement : body.statements()) {
            if (CheckUtils.isEmptyStatement(statement) || statement.is(new Tree.Kind[]{Tree.Kind.RAISE_STMT}) || this.isReturnNotImplemented(statement)) continue;
            return false;
        }
        return true;
    }

    private boolean isReturnNotImplemented(Statement statement) {
        return statement.is(new Tree.Kind[]{Tree.Kind.RETURN_STMT}) && ((ReturnStatement)statement).expressions().stream().allMatch(e -> this.notImplementedTypeChecker.check(e.typeV2()) == TriBool.TRUE);
    }

    private static boolean mightBeOverridingMethod(FunctionDef functionDef) {
        ClassType classType;
        FunctionType functionType = (FunctionType)functionDef.name().typeV2();
        PythonType pythonType = functionType.owner();
        return pythonType instanceof ClassType && ((classType = (ClassType)pythonType).hasUnresolvedHierarchy() || classType.inheritedMember(functionType.name()).isPresent());
    }

    private static class AsyncFeatureVisitor
    extends BaseTreeVisitor {
        private boolean asyncFeatureFound = false;

        private AsyncFeatureVisitor() {
        }

        public boolean hasAsyncFeature() {
            return this.asyncFeatureFound;
        }

        public void visitAwaitExpression(AwaitExpression awaitExpression) {
            this.asyncFeatureFound = true;
        }

        public void visitForStatement(ForStatement forStatement) {
            if (forStatement.isAsync()) {
                this.asyncFeatureFound = true;
                return;
            }
            if (!this.asyncFeatureFound) {
                super.visitForStatement(forStatement);
            }
        }

        public void visitWithStatement(WithStatement withStatement) {
            if (withStatement.isAsync()) {
                this.asyncFeatureFound = true;
            }
            if (!this.asyncFeatureFound) {
                super.visitWithStatement(withStatement);
            }
        }

        public void visitYieldStatement(YieldStatement yieldStatement) {
            this.asyncFeatureFound = true;
        }

        public void visitYieldExpression(YieldExpression yieldExpression) {
            this.asyncFeatureFound = true;
        }

        public void visitFunctionDef(FunctionDef functionDef) {
        }

        public void visitComprehensionFor(ComprehensionFor tree) {
            this.asyncFeatureFound |= tree.asyncToken() != null;
            super.visitComprehensionFor(tree);
        }

        protected void scan(@Nullable Tree tree) {
            if (!this.asyncFeatureFound && tree != null) {
                tree.accept((TreeVisitor)this);
            }
        }
    }
}

