/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.LocationInFile;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonVisitorCheck;
import org.sonar.plugins.python.api.symbols.ClassSymbol;
import org.sonar.plugins.python.api.symbols.FunctionSymbol;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.ComprehensionIf;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.HasSymbol;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.python.cfg.fixpoint.ReachingDefinitionsAnalysis;
import org.sonar.python.checks.utils.CheckUtils;

@Rule(key="S5797")
public class ConstantConditionCheck
extends PythonVisitorCheck {
    private static final String MESSAGE = "Replace this expression; used as a condition it will always be constant.";
    private static final List<String> ACCEPTED_DECORATORS = List.of("overload", "staticmethod", "classmethod");
    private ReachingDefinitionsAnalysis reachingDefinitionsAnalysis;

    public void visitFileInput(FileInput fileInput) {
        this.reachingDefinitionsAnalysis = new ReachingDefinitionsAnalysis(this.getContext().pythonFile());
        super.visitFileInput(fileInput);
    }

    public void visitIfStatement(IfStatement ifStatement) {
        this.checkConstantCondition(ifStatement.condition());
        this.scan((Tree)ifStatement.body());
        this.scan(ifStatement.elifBranches());
        this.scan((Tree)ifStatement.elseBranch());
    }

    public void visitConditionalExpression(ConditionalExpression conditionalExpression) {
        this.checkConstantCondition(conditionalExpression.condition());
        super.visitConditionalExpression(conditionalExpression);
    }

    public void visitComprehensionIf(ComprehensionIf comprehensionIf) {
        this.checkConstantCondition(comprehensionIf.condition());
        super.visitComprehensionIf(comprehensionIf);
    }

    private void checkConstantCondition(Expression condition) {
        Expression constantBooleanExpression = ConstantConditionCheck.getConstantBooleanExpression(condition);
        if (constantBooleanExpression != null) {
            this.addIssue((Tree)constantBooleanExpression, MESSAGE);
        }
        this.checkExpression(condition);
    }

    private static Expression getConstantBooleanExpression(Expression condition) {
        if (condition.is(new Tree.Kind[]{Tree.Kind.AND, Tree.Kind.OR})) {
            BinaryExpression binaryExpression = (BinaryExpression)condition;
            if (CheckUtils.isConstant(binaryExpression.leftOperand())) {
                return binaryExpression.leftOperand();
            }
            if (CheckUtils.isConstant(binaryExpression.rightOperand())) {
                return binaryExpression.rightOperand();
            }
        }
        if (condition.is(new Tree.Kind[]{Tree.Kind.NOT}) && CheckUtils.isConstant(((UnaryExpression)condition).expression())) {
            return ((UnaryExpression)condition).expression();
        }
        return null;
    }

    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        if (!binaryExpression.is(new Tree.Kind[]{Tree.Kind.AND, Tree.Kind.OR})) {
            return;
        }
        if (CheckUtils.isConstant(binaryExpression.leftOperand())) {
            this.addIssue((Tree)binaryExpression.leftOperand(), MESSAGE);
            return;
        }
        if (binaryExpression.leftOperand().is(new Tree.Kind[]{Tree.Kind.AND, Tree.Kind.OR})) {
            BinaryExpression leftOperand = (BinaryExpression)binaryExpression.leftOperand();
            this.checkExpression(leftOperand.leftOperand());
            if (!leftOperand.is(new Tree.Kind[]{Tree.Kind.AND}) || !binaryExpression.is(new Tree.Kind[]{Tree.Kind.OR})) {
                this.checkExpression(leftOperand.rightOperand());
            }
            return;
        }
        if (binaryExpression.rightOperand().is(new Tree.Kind[]{Tree.Kind.AND, Tree.Kind.OR})) {
            this.checkExpression(((BinaryExpression)binaryExpression.rightOperand()).leftOperand());
        }
    }

    private void checkExpression(Expression expression) {
        Expression lastAssignedValue;
        Set valuesAtLocation;
        Symbol symbol;
        if (CheckUtils.isConstant(expression)) {
            this.addIssue((Tree)expression, MESSAGE);
            return;
        }
        if ((expression.is(new Tree.Kind[]{Tree.Kind.NAME}) || expression.is(new Tree.Kind[]{Tree.Kind.QUALIFIED_EXPR})) && (symbol = ((HasSymbol)expression).symbol()) != null && ConstantConditionCheck.isClassOrFunction(symbol)) {
            this.raiseIssueOnClassOrFunction(expression, symbol);
            return;
        }
        if (expression.is(new Tree.Kind[]{Tree.Kind.NAME}) && (valuesAtLocation = this.reachingDefinitionsAnalysis.valuesAtLocation((Name)expression)).size() == 1 && CheckUtils.isImmutableConstant(lastAssignedValue = (Expression)valuesAtLocation.iterator().next())) {
            this.addIssue((Tree)expression, MESSAGE).secondary((Tree)lastAssignedValue, "Last assignment.");
        }
    }

    private void raiseIssueOnClassOrFunction(Expression expression, Symbol symbol) {
        PythonCheck.PreciseIssue issue = this.addIssue((Tree)expression, MESSAGE);
        LocationInFile locationInFile = ConstantConditionCheck.locationForClassOrFunction(symbol);
        if (locationInFile != null) {
            String type = symbol.is(new Symbol.Kind[]{Symbol.Kind.CLASS}) ? "Class" : "Function";
            issue.secondary(locationInFile, String.format("%s definition.", type));
        }
    }

    private static boolean isClassOrFunction(Symbol symbol) {
        if (symbol.is(new Symbol.Kind[]{Symbol.Kind.CLASS})) {
            return true;
        }
        if (symbol.is(new Symbol.Kind[]{Symbol.Kind.FUNCTION})) {
            return ACCEPTED_DECORATORS.containsAll(((FunctionSymbol)symbol).decorators());
        }
        return false;
    }

    private static LocationInFile locationForClassOrFunction(Symbol symbol) {
        return symbol.is(new Symbol.Kind[]{Symbol.Kind.CLASS}) ? ((ClassSymbol)symbol).definitionLocation() : ((FunctionSymbol)symbol).definitionLocation();
    }
}

