/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.checks.utils.AwsLambdaChecksUtils;
import org.sonar.python.checks.utils.Expressions;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S6246")
public class AwsLambdaCrossCallCheck
extends PythonSubscriptionCheck {
    public static final String INVOCATION_TYPE_ARGUMENT_KEYWORD = "InvocationType";
    public static final String REQUEST_RESPONSE_INVOCATION_TYPE_ARGUMENT_VALUE = "RequestResponse";
    private TypeCheckBuilder isBoto3ClientCheck;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initializeCheck);
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::check);
    }

    private void initializeCheck(SubscriptionContext ctx) {
        this.isBoto3ClientCheck = ctx.typeChecker().typeCheckBuilder().isTypeWithFqn("botocore.client.BaseClient.invoke");
    }

    private void check(SubscriptionContext ctx) {
        FunctionDef functionDef;
        Tree tree;
        CallExpression callExpression = (CallExpression)ctx.syntaxNode();
        if (this.isBoto3ClientCheck.check(TreeUtils.inferSingleAssignedExpressionType((Expression)callExpression.callee())).isTrue() && (tree = TreeUtils.firstAncestorOfKind((Tree)callExpression, (Tree.Kind[])new Tree.Kind[]{Tree.Kind.FUNCDEF})) instanceof FunctionDef && AwsLambdaChecksUtils.isLambdaHandler(ctx, functionDef = (FunctionDef)tree) && AwsLambdaCrossCallCheck.hasInvalidArgumentValue(callExpression)) {
            ctx.addIssue((Tree)callExpression, "Avoid synchronous calls to other lambdas");
        }
    }

    private static boolean hasInvalidArgumentValue(CallExpression callExpression) {
        return Optional.ofNullable(TreeUtils.argumentByKeyword((String)INVOCATION_TYPE_ARGUMENT_KEYWORD, (List)callExpression.arguments())).map(RegularArgument::expression).flatMap(Expressions::ifNameGetSingleAssignedNonNameValue).flatMap(TreeUtils.toOptionalInstanceOfMapper(StringLiteral.class)).map(StringLiteral::trimmedQuotesValue).filter(REQUEST_RESPONSE_INVOCATION_TYPE_ARGUMENT_VALUE::equals).isPresent();
    }
}

