/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.List;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.TriBool;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.quickfix.TextEditUtils;
import org.sonar.python.tree.TreeUtils;
import org.sonar.python.types.v2.TypeCheckBuilder;

@Rule(key="S7504")
public class UnnecessaryListCastCheck
extends PythonSubscriptionCheck {
    private TypeCheckBuilder isListCallCheck;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, this::initChecks);
        context.registerSyntaxNodeConsumer(Tree.Kind.FOR_STMT, this::checkForStatements);
        context.registerSyntaxNodeConsumer(Tree.Kind.COMP_FOR, this::checkComprehensions);
    }

    private void initChecks(SubscriptionContext ctx) {
        this.isListCallCheck = ctx.typeChecker().typeCheckBuilder().isBuiltinWithName("list");
    }

    private void checkForStatements(SubscriptionContext ctx) {
        ForStatement stmt = (ForStatement)ctx.syntaxNode();
        this.checkListCastCheck(stmt.testExpressions(), ctx);
    }

    private void checkComprehensions(SubscriptionContext ctx) {
        ComprehensionFor comprehensionFor = (ComprehensionFor)ctx.syntaxNode();
        this.checkListCastCheck(List.of(comprehensionFor.iterable()), ctx);
    }

    private void checkListCastCheck(List<Expression> expressions, SubscriptionContext ctx) {
        this.hasListCallOnIterable(expressions).ifPresent(listCall -> {
            PythonCheck.PreciseIssue issue = ctx.addIssue((Tree)listCall.callee(), "Remove this unnecessary `list()` call on an already iterable object.");
            Optional.ofNullable(TreeUtils.treeToString((Tree)listCall.argumentList(), (boolean)false)).map(replacementText -> TextEditUtils.replace((Tree)listCall, (String)replacementText)).map(textEdit -> PythonQuickFix.newQuickFix((String)"Remove the \"list\" call", (PythonTextEdit[])new PythonTextEdit[]{textEdit})).ifPresent(arg_0 -> ((PythonCheck.PreciseIssue)issue).addQuickFix(arg_0));
        });
    }

    private Optional<CallExpression> hasListCallOnIterable(List<Expression> testExpressions) {
        CallExpression callExpression;
        Expression expression;
        if (testExpressions.size() == 1 && (expression = testExpressions.get(0)) instanceof CallExpression && this.isListCall(callExpression = (CallExpression)expression) && UnnecessaryListCastCheck.hasOnlyOneRegularArg(callExpression)) {
            return Optional.of(callExpression);
        }
        return Optional.empty();
    }

    private boolean isListCall(CallExpression callExpression) {
        return this.isListCallCheck.check(callExpression.callee().typeV2()) == TriBool.TRUE;
    }

    private static boolean hasOnlyOneRegularArg(CallExpression callExpression) {
        return callExpression.arguments().size() == 1 && callExpression.arguments().get(0) instanceof RegularArgument;
    }
}

