/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.Expression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;

@Rule(key="S2208")
public class WildcardImportCheck
extends PythonSubscriptionCheck {
    private static final String MESSAGE = "Import only needed names or import the module and then use its members.";

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            if ("__init__.py".equals(ctx.pythonFile().fileName())) {
                return;
            }
            FileInput fileInput = (FileInput)ctx.syntaxNode();
            StatementList statements = fileInput.statements();
            if (statements == null) {
                return;
            }
            WildcardImportVisitor visitor = new WildcardImportVisitor();
            statements.accept((TreeVisitor)visitor);
            if (visitor.shouldRaiseIssues) {
                visitor.wildcardImports.forEach(importFrom -> ctx.addIssue((Tree)importFrom, MESSAGE));
            }
        });
    }

    private static class WildcardImportVisitor
    extends BaseTreeVisitor {
        private boolean shouldRaiseIssues = false;
        private List<ImportFrom> wildcardImports = new ArrayList<ImportFrom>();

        private WildcardImportVisitor() {
        }

        public void visitImportFrom(ImportFrom pyImportFromTree) {
            if (pyImportFromTree.isWildcardImport()) {
                this.wildcardImports.add(pyImportFromTree);
            }
        }

        public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
            this.shouldRaiseIssues = true;
        }

        public void visitClassDef(ClassDef pyClassDefTree) {
            this.shouldRaiseIssues = true;
        }

        public void visitStatementList(StatementList statementList) {
            this.raiseIssuesIf(() -> statementList.statements().stream().anyMatch(WildcardImportVisitor::mayContainApplicationLogic));
            super.visitStatementList(statementList);
        }

        public void visitAssignmentStatement(AssignmentStatement pyAssignmentStatementTree) {
            List lhsExpressions = pyAssignmentStatementTree.lhsExpressions();
            this.raiseIssuesIf(() -> lhsExpressions.stream().anyMatch(expressionList -> expressionList.expressions().stream().anyMatch(WildcardImportVisitor::isDisallowedAssignment)));
        }

        public void visitCallExpression(CallExpression pyCallExpressionTree) {
            Symbol symbol = pyCallExpressionTree.calleeSymbol();
            this.raiseIssuesIf(() -> symbol == null || !"warnings.warn".equals(symbol.fullyQualifiedName()));
        }

        private void raiseIssuesIf(BooleanSupplier condition) {
            this.shouldRaiseIssues = this.shouldRaiseIssues || condition.getAsBoolean();
        }

        private static boolean isDisallowedAssignment(Expression expression) {
            return !expression.is(new Tree.Kind[]{Tree.Kind.NAME}) || !"__all__".equals(((Name)expression).name());
        }

        private static boolean mayContainApplicationLogic(Tree tree) {
            return tree.is(new Tree.Kind[]{Tree.Kind.WHILE_STMT, Tree.Kind.FOR_STMT, Tree.Kind.WITH_STMT, Tree.Kind.COMPOUND_ASSIGNMENT});
        }
    }
}

