/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.text.MessageFormat;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.metrics.ComplexityVisitor;

@Rule(key="FileComplexity")
public class FileComplexityCheck
extends PythonSubscriptionCheck {
    private static final int DEFAULT_MAXIMUM_FILE_COMPLEXITY_THRESHOLD = 200;
    @RuleProperty(key="maximumFileComplexityThreshold", description="The maximum authorized complexity in file", defaultValue="200")
    int maximumFileComplexityThreshold = 200;

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            int complexity = ComplexityVisitor.complexity((Tree)ctx.syntaxNode());
            if (complexity > this.maximumFileComplexityThreshold) {
                String message = MessageFormat.format("File has a complexity of {0,number,integer} which is greater than {1,number,integer} authorized.", complexity, this.maximumFileComplexityThreshold);
                ctx.addFileIssue(message).withCost(complexity - this.maximumFileComplexityThreshold);
            }
        });
    }
}

