/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TypeParams;
import org.sonar.python.tree.TreeUtils;

@Rule(key="S5953")
public class UndefinedSymbolsCheck
extends PythonSubscriptionCheck {
    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.FILE_INPUT, ctx -> {
            FileInput fileInput = (FileInput)ctx.syntaxNode();
            if (UndefinedSymbolsCheck.importsManipulatedAllProperty(fileInput)) {
                return;
            }
            UnresolvedSymbolsVisitor unresolvedSymbolsVisitor = new UnresolvedSymbolsVisitor();
            fileInput.accept((TreeVisitor)unresolvedSymbolsVisitor);
            if (!unresolvedSymbolsVisitor.callGlobalsOrLocals && !unresolvedSymbolsVisitor.hasWildcardImport) {
                UndefinedSymbolsCheck.addNameIssues(unresolvedSymbolsVisitor.nameIssues, ctx);
            }
        });
    }

    private static boolean importsManipulatedAllProperty(FileInput fileInput) {
        return fileInput.globalVariables().stream().anyMatch(s -> "__all__".equals(s.name()) && s.fullyQualifiedName() != null);
    }

    private static void addNameIssues(Map<String, List<Name>> nameIssues, SubscriptionContext subscriptionContext) {
        nameIssues.forEach((name, list) -> {
            Name first = (Name)list.get(0);
            PythonCheck.PreciseIssue issue = subscriptionContext.addIssue((Tree)first, first.name() + " is not defined. Change its name or define it before using it");
            list.stream().skip(1L).forEach(n -> issue.secondary((Tree)n, null));
        });
    }

    private static class UnresolvedSymbolsVisitor
    extends BaseTreeVisitor {
        private boolean hasWildcardImport = false;
        private boolean callGlobalsOrLocals = false;
        private final Map<String, List<Name>> nameIssues = new HashMap<String, List<Name>>();

        private UnresolvedSymbolsVisitor() {
        }

        public void visitName(Name name) {
            if (name.isVariable() && name.symbol() == null && !name.name().startsWith("_") && !UnresolvedSymbolsVisitor.isTypeVar(name)) {
                this.nameIssues.computeIfAbsent(name.name(), k -> new ArrayList()).add(name);
            }
        }

        private static boolean isTypeVar(Name name) {
            return TreeUtils.firstAncestor((Tree)name, tree -> UnresolvedSymbolsVisitor.classWithTypeVar(tree, name)) != null;
        }

        private static boolean classWithTypeVar(Tree tree, Name name) {
            if (tree instanceof ClassDef) {
                ClassDef classDef = (ClassDef)tree;
                return UnresolvedSymbolsVisitor.hasTypeVar(classDef.typeParams(), name);
            }
            return false;
        }

        private static boolean hasTypeVar(@Nullable TypeParams typeParams, Name name) {
            if (typeParams != null && !typeParams.typeParamsList().isEmpty()) {
                return typeParams.typeParamsList().stream().anyMatch(typeParam -> typeParam.name().name().equals(name.name()));
            }
            return false;
        }

        public void visitImportFrom(ImportFrom importFrom) {
            this.hasWildcardImport |= importFrom.wildcard() != null;
            super.visitImportFrom(importFrom);
        }

        public void visitCallExpression(CallExpression callExpression) {
            if (callExpression.callee().is(new Tree.Kind[]{Tree.Kind.NAME})) {
                String name = ((Name)callExpression.callee()).name();
                this.callGlobalsOrLocals |= "globals".equals(name) || "locals".equals(name);
            }
            super.visitCallExpression(callExpression);
        }
    }
}

