/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks.cdk;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionCheck;
import org.sonar.plugins.python.api.SubscriptionContext;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.Tree;

public abstract class AbstractCdkResourceCheck
extends PythonSubscriptionCheck {
    private final Map<String, BiConsumer<SubscriptionContext, CallExpression>> fqnCallConsumers = new HashMap<String, BiConsumer<SubscriptionContext, CallExpression>>();

    public void initialize(SubscriptionCheck.Context context) {
        context.registerSyntaxNodeConsumer(Tree.Kind.CALL_EXPR, this::visitNode);
        this.registerFqnConsumer();
    }

    protected void visitNode(SubscriptionContext ctx) {
        CallExpression node = (CallExpression)ctx.syntaxNode();
        Optional.ofNullable(node.calleeSymbol()).map(Symbol::fullyQualifiedName).map(fqn -> this.fqnCallConsumers.getOrDefault(fqn, null)).ifPresent(consumer -> consumer.accept(ctx, node));
    }

    protected abstract void registerFqnConsumer();

    protected void checkFqn(String fqn, BiConsumer<SubscriptionContext, CallExpression> consumer) {
        this.fqnCallConsumers.put(fqn, consumer);
    }

    protected void checkFqns(Collection<String> suffixes, BiConsumer<SubscriptionContext, CallExpression> consumer) {
        suffixes.forEach(suffix -> this.checkFqn((String)suffix, consumer));
    }
}

