/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.sonar.sslr.api.RecognitionException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.python.PythonInputFile;
import org.sonarsource.analyzer.commons.ProgressReport;

public abstract class Scanner {
    private static final Logger LOG = LoggerFactory.getLogger(Scanner.class);
    private static final String FAIL_FAST_PROPERTY_NAME = "sonar.internal.analysis.failFast";
    protected final SensorContext context;

    protected Scanner(SensorContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(List<PythonInputFile> files, SensorContext context) {
        ProgressReport progressReport = new ProgressReport(this.name() + " progress", TimeUnit.SECONDS.toMillis(10L));
        String name = this.name();
        LOG.info("Starting {}", (Object)name);
        List<String> filenames = files.stream().map(PythonInputFile::wrappedFile).map(InputFile::toString).toList();
        int numScannedWithoutParsing = 0;
        progressReport.start(filenames);
        for (PythonInputFile file : files) {
            if (context.isCancelled()) {
                progressReport.cancel();
                return;
            }
            try {
                boolean successfullyScannedWithoutParsing = false;
                if (this.canBeScannedWithoutParsing(file)) {
                    successfullyScannedWithoutParsing = this.scanFileWithoutParsing(file);
                }
                if (!successfullyScannedWithoutParsing) {
                    this.scanFile(file);
                    continue;
                }
                ++numScannedWithoutParsing;
            }
            catch (Exception e) {
                this.processException(e, file);
                if (!context.config().getBoolean(FAIL_FAST_PROPERTY_NAME).orElse(false).booleanValue() || Scanner.isParseErrorOnTestFile(file, e)) continue;
                throw new IllegalStateException("Exception when analyzing " + file, e);
            }
            finally {
                progressReport.nextFile();
            }
        }
        this.endOfAnalysis();
        progressReport.stop();
        this.reportStatistics(numScannedWithoutParsing, files.size());
    }

    protected abstract String name();

    protected abstract void scanFile(PythonInputFile var1) throws IOException;

    protected boolean scanFileWithoutParsing(PythonInputFile file) throws IOException {
        return false;
    }

    protected void endOfAnalysis() {
    }

    protected abstract void processException(Exception var1, PythonInputFile var2);

    protected void reportStatistics(int numSkippedFiles, int numTotalFiles) {
    }

    public boolean canBeScannedWithoutParsing(PythonInputFile inputFile) {
        return false;
    }

    private static boolean isParseErrorOnTestFile(PythonInputFile file, Exception e) {
        return e instanceof RecognitionException && file.wrappedFile().type() == InputFile.Type.TEST;
    }
}

