/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.plugins.python.PythonChecks;
import org.sonar.plugins.python.PythonInputFile;
import org.sonar.plugins.python.PythonInputFileImpl;
import org.sonar.plugins.python.PythonScanner;
import org.sonar.plugins.python.SensorTelemetryStorage;
import org.sonar.plugins.python.TelemetryMetricKey;
import org.sonar.plugins.python.api.ProjectPythonVersion;
import org.sonar.plugins.python.api.PythonCustomRuleRepository;
import org.sonar.plugins.python.api.PythonFileConsumer;
import org.sonar.plugins.python.api.PythonVersionUtils;
import org.sonar.plugins.python.api.SonarLintCache;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.architecture.ArchitectureCallbackWrapper;
import org.sonar.plugins.python.editions.OpenSourceRepositoryInfoProvider;
import org.sonar.plugins.python.editions.RepositoryInfoProvider;
import org.sonar.plugins.python.indexer.PythonIndexer;
import org.sonar.plugins.python.indexer.SonarQubePythonIndexer;
import org.sonar.plugins.python.warnings.AnalysisWarningsWrapper;
import org.sonar.python.caching.CacheContextImpl;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.types.TypeShed;
import org.sonarsource.performance.measure.PerformanceMeasure;

@DependedUpon(value={"org.sonar.plugins.python.PythonSensor_before_com.sonarsource.dbd.SonarLintPythonBugDetectionSensor"})
public final class PythonSensor
implements Sensor {
    private static final String PERFORMANCE_MEASURE_PROPERTY = "sonar.python.performance.measure";
    private static final String PERFORMANCE_MEASURE_FILE_PATH_PROPERTY = "sonar.python.performance.measure.path";
    private static final String PERFORMANCE_MEASURE_DESTINATION_FILE = "sonar-python-performance-measure.json";
    private final PythonChecks checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private final PythonIndexer indexer;
    private final PythonFileConsumer architectureCallback;
    private final SonarLintCache sonarLintCache;
    private final AnalysisWarningsWrapper analysisWarnings;
    private static final Logger LOG = LoggerFactory.getLogger(PythonSensor.class);
    static final String UNSET_VERSION_WARNING = "Your code is analyzed as compatible with all Python 3 versions by default. You can get a more precise analysis by setting the exact Python version in your configuration via the parameter \"sonar.python.version\"";
    private final SensorTelemetryStorage sensorTelemetryStorage;

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, AnalysisWarningsWrapper analysisWarnings, ArchitectureCallbackWrapper architectureCallbackWrapper) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, null, null, null, analysisWarnings, new RepositoryInfoProvider[]{new OpenSourceRepositoryInfoProvider()}, architectureCallbackWrapper);
    }

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, @Nullable PythonCustomRuleRepository[] customRuleRepositories, AnalysisWarningsWrapper analysisWarnings, ArchitectureCallbackWrapper architectureCallbackWrapper) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, customRuleRepositories, null, null, analysisWarnings, new RepositoryInfoProvider[]{new OpenSourceRepositoryInfoProvider()}, architectureCallbackWrapper);
    }

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, PythonIndexer indexer, SonarLintCache sonarLintCache, AnalysisWarningsWrapper analysisWarnings, ArchitectureCallbackWrapper architectureCallbackWrapper) {
        this(fileLinesContextFactory, checkFactory, noSonarFilter, null, indexer, sonarLintCache, analysisWarnings, new RepositoryInfoProvider[]{new OpenSourceRepositoryInfoProvider()}, architectureCallbackWrapper);
    }

    public PythonSensor(FileLinesContextFactory fileLinesContextFactory, CheckFactory checkFactory, NoSonarFilter noSonarFilter, @Nullable PythonCustomRuleRepository[] customRuleRepositories, @Nullable PythonIndexer indexer, @Nullable SonarLintCache sonarLintCache, AnalysisWarningsWrapper analysisWarnings, RepositoryInfoProvider[] editionMetadataProviders, ArchitectureCallbackWrapper architectureUDGBuilderWrapper) {
        this.checks = PythonSensor.createPythonChecks(checkFactory, editionMetadataProviders).addCustomChecks(customRuleRepositories);
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.indexer = indexer;
        this.sonarLintCache = sonarLintCache;
        this.analysisWarnings = analysisWarnings;
        this.sensorTelemetryStorage = new SensorTelemetryStorage();
        this.architectureCallback = architectureUDGBuilderWrapper.architectureUdgBuilder();
    }

    private static PythonChecks createPythonChecks(CheckFactory checkFactory, RepositoryInfoProvider[] editionMetadataProviders) {
        PythonChecks checks = new PythonChecks(checkFactory);
        for (RepositoryInfoProvider repositoryInfoProvider : editionMetadataProviders) {
            RepositoryInfoProvider.RepositoryInfo repositoryInfo = repositoryInfoProvider.getInfo();
            checks.addChecks(repositoryInfo.repositoryKey(), repositoryInfo.checks());
        }
        return checks;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("py").name("Python Sensor");
    }

    public void execute(SensorContext context) {
        PerformanceMeasure.Duration durationReport = PythonSensor.createPerformanceMeasureReport(context);
        List<PythonInputFile> pythonFiles = PythonSensor.getInputFiles(context);
        String[] pythonVersionParameter = context.config().getStringArray("sonar.python.version");
        if (pythonVersionParameter.length == 0 && context.runtime().getProduct() != SonarProduct.SONARLINT) {
            LOG.warn(UNSET_VERSION_WARNING);
            this.analysisWarnings.addUnique(UNSET_VERSION_WARNING);
        }
        if (pythonVersionParameter.length != 0) {
            ProjectPythonVersion.setCurrentVersions((Set)PythonVersionUtils.fromStringArray((String[])pythonVersionParameter));
        }
        this.updatePythonVersionTelemetry(context, pythonVersionParameter);
        CacheContextImpl cacheContext = CacheContextImpl.of((SensorContext)context);
        PythonIndexer pythonIndexer = this.indexer != null ? this.indexer : new SonarQubePythonIndexer(pythonFiles, (CacheContext)cacheContext, context);
        pythonIndexer.setSonarLintCache(this.sonarLintCache);
        TypeShed.setProjectLevelSymbolTable((ProjectLevelSymbolTable)pythonIndexer.projectLevelSymbolTable());
        PythonScanner scanner = new PythonScanner(context, this.checks, this.fileLinesContextFactory, this.noSonarFilter, PythonParser.create(), pythonIndexer, this.architectureCallback);
        scanner.execute(pythonFiles, context);
        this.updateDatabricksTelemetry(scanner);
        this.sensorTelemetryStorage.send(context);
        durationReport.stop();
    }

    private static List<PythonInputFile> getInputFiles(SensorContext context) {
        FilePredicates p = context.fileSystem().predicates();
        Iterable it = context.fileSystem().inputFiles(p.and(new FilePredicate[]{p.hasLanguage("py")}));
        ArrayList list = new ArrayList();
        it.forEach(f -> list.add(new PythonInputFileImpl(f)));
        return Collections.unmodifiableList(list);
    }

    private void updateDatabricksTelemetry(PythonScanner scanner) {
        this.sensorTelemetryStorage.updateMetric(TelemetryMetricKey.PYTHON_DATABRICKS_FOUND, scanner.getFoundDatabricks());
    }

    private void updatePythonVersionTelemetry(SensorContext context, String[] pythonVersionParameter) {
        if (context.runtime().getProduct() == SonarProduct.SONARLINT) {
            return;
        }
        this.sensorTelemetryStorage.updateMetric(TelemetryMetricKey.PYTHON_VERSION_SET_KEY, pythonVersionParameter.length != 0);
        if (pythonVersionParameter.length != 0) {
            this.sensorTelemetryStorage.updateMetric(TelemetryMetricKey.PYTHON_VERSION_KEY, String.join((CharSequence)",", pythonVersionParameter));
        }
    }

    private static PerformanceMeasure.Duration createPerformanceMeasureReport(SensorContext context) {
        return PerformanceMeasure.reportBuilder().activate(context.config().getBoolean(PERFORMANCE_MEASURE_PROPERTY).orElse(Boolean.FALSE).booleanValue()).toFile(context.config().get(PERFORMANCE_MEASURE_FILE_PATH_PROPERTY).filter(path -> !path.isEmpty()).orElseGet(() -> Optional.ofNullable(context.fileSystem().workDir()).filter(File::exists).map(file -> file.toPath().resolve(PERFORMANCE_MEASURE_DESTINATION_FILE).toString()).orElse(null))).appendMeasurementCost().start("PythonSensor");
    }
}

