/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.Version;
import org.sonar.plugins.python.TelemetryMetricKey;

public class SensorTelemetryStorage {
    private static final Logger LOG = LoggerFactory.getLogger(SensorTelemetryStorage.class);
    private final Map<TelemetryMetricKey, String> data = new EnumMap<TelemetryMetricKey, String>(TelemetryMetricKey.class);

    public void send(SensorContext sensorContext) {
        try {
            Version apiVersion = sensorContext.runtime().getApiVersion();
            if (apiVersion.isGreaterThanOrEqual(Version.create((int)10, (int)9))) {
                this.data.forEach((k, v) -> {
                    LOG.debug("Collected metric: {}={}", (Object)k, v);
                    sensorContext.addTelemetryProperty(k.key(), v);
                });
            } else {
                LOG.debug("Skipping sending metrics because the plugin API version is {}", (Object)apiVersion);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to send metrics", (Throwable)e);
        }
    }

    public void updateMetric(TelemetryMetricKey key, String value) {
        this.data.put(key, value);
    }

    public void updateMetric(TelemetryMetricKey key, int value) {
        this.data.put(key, String.valueOf(value));
    }

    public void updateMetric(TelemetryMetricKey key, boolean value) {
        this.data.put(key, SensorTelemetryStorage.boolToString(value));
    }

    private static String boolToString(boolean value) {
        return value ? "1" : "0";
    }
}

