/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.caching;

import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.python.index.Descriptor;
import org.sonar.python.index.DescriptorsToProtobuf;
import org.sonar.python.types.protobuf.DescriptorsProtos;

public class Caching {
    private final CacheContext cacheContext;
    public static final String IMPORTS_MAP_CACHE_KEY_PREFIX = "python:imports:";
    public static final String PROJECT_SYMBOL_TABLE_CACHE_KEY_PREFIX = "python:descriptors:";
    public static final String PROJECT_FILES_KEY = "python:files";
    public static final String CONTENT_HASHES_KEY = "python:content_hashes:";
    public static final String TYPESHED_MODULES_KEY = "python:typeshed_modules";
    public static final String CACHE_VERSION_KEY = "python:cache_version";
    public static final String CPD_TOKENS_CACHE_KEY_PREFIX = "python:cpd:data:";
    public static final String CPD_TOKENS_STRING_TABLE_KEY_PREFIX = "python:cpd:stringTable:";
    private static final Logger LOG = LoggerFactory.getLogger(Caching.class);
    public final String cacheVersion;

    public Caching(CacheContext cacheContext, String cacheVersion) {
        this.cacheContext = cacheContext;
        this.cacheVersion = cacheVersion;
    }

    public void writeImportsMapEntry(String fileKey, Set<String> imports) {
        byte[] importData = String.join((CharSequence)";", imports).getBytes(StandardCharsets.UTF_8);
        String cacheKey = Caching.importsMapCacheKey(fileKey);
        this.cacheContext.getWriteCache().write(cacheKey, importData);
    }

    public void writeFileContentHash(String fileKey, byte[] hash) {
        String cacheKey = Caching.fileContentHashCacheKey(fileKey);
        this.cacheContext.getWriteCache().write(cacheKey, hash);
    }

    public void writeFilesList(List<String> mainFiles) {
        byte[] projectFiles = String.join((CharSequence)";", mainFiles).getBytes(StandardCharsets.UTF_8);
        this.cacheContext.getWriteCache().write(PROJECT_FILES_KEY, projectFiles);
    }

    public void writeTypeshedModules(Set<String> stubModules) {
        byte[] stubModulesBytes = String.join((CharSequence)";", stubModules).getBytes(StandardCharsets.UTF_8);
        this.cacheContext.getWriteCache().write(TYPESHED_MODULES_KEY, stubModulesBytes);
    }

    public void writeCacheVersion() {
        this.cacheContext.getWriteCache().write(CACHE_VERSION_KEY, this.cacheVersion.getBytes(StandardCharsets.UTF_8));
    }

    public void writeProjectLevelSymbolTableEntry(String fileKey, Set<Descriptor> descriptors) {
        String cacheKey = Caching.projectSymbolTableCacheKey(fileKey);
        this.cacheContext.getWriteCache().write(cacheKey, DescriptorsToProtobuf.toProtobufModuleDescriptor(descriptors).toByteArray());
    }

    public void copyFromPrevious(String fileKey) {
        this.cacheContext.getWriteCache().copyFromPrevious(Caching.importsMapCacheKey(fileKey));
        this.cacheContext.getWriteCache().copyFromPrevious(Caching.projectSymbolTableCacheKey(fileKey));
        this.cacheContext.getWriteCache().copyFromPrevious(Caching.fileContentHashCacheKey(fileKey));
    }

    @CheckForNull
    public Set<Descriptor> readProjectLevelSymbolTableEntry(String fileKey) {
        byte[] bytes;
        String key = Caching.projectSymbolTableCacheKey(fileKey);
        if (this.cacheContext.getReadCache().contains(key) && (bytes = this.cacheContext.getReadCache().readBytes(key)) != null) {
            try {
                return DescriptorsToProtobuf.fromProtobuf((DescriptorsProtos.ModuleDescriptor)DescriptorsProtos.ModuleDescriptor.parseFrom((byte[])bytes));
            }
            catch (InvalidProtocolBufferException e) {
                LOG.debug("Failed to deserialize project level symbol table entry for module: \"{}\"", (Object)fileKey);
            }
        }
        return null;
    }

    @CheckForNull
    public Set<String> readImportMapEntry(String fileKey) {
        String cacheKey = Caching.importsMapCacheKey(fileKey);
        byte[] bytes = this.cacheContext.getReadCache().readBytes(cacheKey);
        if (bytes != null) {
            return new HashSet<String>(Arrays.asList(new String(bytes, StandardCharsets.UTF_8).split(";")));
        }
        return null;
    }

    public byte[] readFileContentHash(String fileKey) {
        String cacheKey = Caching.fileContentHashCacheKey(fileKey);
        return this.cacheContext.getReadCache().readBytes(cacheKey);
    }

    public Set<String> readFilesList() {
        return this.readSet(PROJECT_FILES_KEY);
    }

    public Set<String> readTypeshedModules() {
        return this.readSet(TYPESHED_MODULES_KEY);
    }

    private Set<String> readSet(String cacheKey) {
        byte[] bytes = this.cacheContext.getReadCache().readBytes(cacheKey);
        if (bytes != null) {
            return new HashSet<String>(Arrays.asList(new String(bytes, StandardCharsets.UTF_8).split(";")));
        }
        return Collections.emptySet();
    }

    public boolean isCacheVersionUpToDate() {
        byte[] bytes = this.cacheContext.getReadCache().readBytes(CACHE_VERSION_KEY);
        if (bytes != null) {
            String retrievedVersion = new String(bytes, StandardCharsets.UTF_8);
            if (retrievedVersion.equals(this.cacheVersion)) {
                LOG.debug("Cache version still up to date: \"{}\".", (Object)this.cacheVersion);
                return true;
            }
            LOG.info("The cache version has changed since the previous analysis, cached data will not be used during this analysis. Retrieved: \"{}\". Current version: \"{}\".", (Object)retrievedVersion, (Object)this.cacheVersion);
        }
        return false;
    }

    public boolean isCacheEnabled() {
        return this.cacheContext.isCacheEnabled();
    }

    public CacheContext cacheContext() {
        return this.cacheContext;
    }

    public static String importsMapCacheKey(String key) {
        return IMPORTS_MAP_CACHE_KEY_PREFIX + key.replace('\\', '/');
    }

    public static String projectSymbolTableCacheKey(String key) {
        return PROJECT_SYMBOL_TABLE_CACHE_KEY_PREFIX + key.replace('\\', '/');
    }

    public static String fileContentHashCacheKey(String key) {
        return CONTENT_HASHES_KEY + key.replace('\\', '/');
    }
}

