/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.bandit;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.JSONParser;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public class BanditJsonReportReader {
    private final JSONParser jsonParser = new JSONParser();
    private final Consumer<Issue> consumer;

    private BanditJsonReportReader(Consumer<Issue> consumer) {
        this.consumer = consumer;
    }

    static void read(InputStream in, Consumer<Issue> consumer) throws IOException, ParseException {
        new BanditJsonReportReader(consumer).read(in);
    }

    private void read(InputStream in) throws IOException, ParseException {
        JSONObject rootObject = (JSONObject)this.jsonParser.parse((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        JSONArray files = (JSONArray)rootObject.get((Object)"results");
        if (files != null) {
            files.stream().forEach(this::onResult);
        }
    }

    private void onResult(JSONObject result) {
        Issue issue = new Issue();
        issue.ruleKey = (String)result.get((Object)"test_id");
        issue.filePath = (String)result.get((Object)"filename");
        issue.message = (String)result.get((Object)"issue_text");
        issue.lineNumber = BanditJsonReportReader.toInteger(result.get((Object)"line_number"));
        issue.severity = (String)result.get((Object)"issue_severity");
        issue.confidence = (String)result.get((Object)"issue_confidence");
        this.consumer.accept(issue);
    }

    private static Integer toInteger(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        return null;
    }

    public static class Issue {
        @Nullable
        String filePath;
        @Nullable
        String ruleKey;
        @Nullable
        String message;
        @Nullable
        Integer lineNumber;
        @Nullable
        String severity;
        @Nullable
        String confidence;
    }
}

