/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.indexer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cache.ReadCache;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonar.plugins.python.PythonInputFile;
import org.sonar.plugins.python.PythonInputFileImpl;
import org.sonar.plugins.python.api.SonarLintCache;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.api.caching.PythonReadCache;
import org.sonar.plugins.python.api.caching.PythonWriteCache;
import org.sonar.plugins.python.indexer.PythonIndexer;
import org.sonar.python.caching.CacheContextImpl;
import org.sonar.python.caching.PythonReadCacheImpl;
import org.sonar.python.caching.PythonWriteCacheImpl;
import org.sonar.python.project.config.ProjectConfigurationBuilder;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.sonarlint.plugin.api.module.file.ModuleFileEvent;
import org.sonarsource.sonarlint.plugin.api.module.file.ModuleFileListener;
import org.sonarsource.sonarlint.plugin.api.module.file.ModuleFileSystem;

@SonarLintSide(lifespan="MODULE")
public class SonarLintPythonIndexer
extends PythonIndexer
implements ModuleFileListener {
    private final ModuleFileSystem moduleFileSystem;
    private CacheContext cacheContext;
    private final Map<String, InputFile> indexedFiles = new HashMap<String, InputFile>();
    private static final Logger LOG = LoggerFactory.getLogger(SonarLintPythonIndexer.class);
    private boolean shouldBuildProjectSymbolTable = true;
    private static final long DEFAULT_MAX_LINES_FOR_INDEXING = 300000L;
    private static final String MAX_LINES_PROPERTY = "sonar.python.sonarlint.indexing.maxlines";

    public SonarLintPythonIndexer(ModuleFileSystem moduleFileSystem, ProjectConfigurationBuilder projectConfigurationBuilder) {
        super(projectConfigurationBuilder);
        this.moduleFileSystem = moduleFileSystem;
    }

    @Override
    public void buildOnce(SensorContext context) {
        if (!this.shouldBuildProjectSymbolTable) {
            return;
        }
        this.projectBaseDirAbsolutePath = context.fileSystem().baseDir().getAbsolutePath();
        this.shouldBuildProjectSymbolTable = false;
        List<PythonInputFile> files = SonarLintPythonIndexer.getInputFiles(this.moduleFileSystem);
        this.collectPackageNames(files);
        long nLines = files.stream().map(PythonInputFile::wrappedFile).map(InputFile::lines).mapToLong(Integer::longValue).sum();
        long maxLinesForIndexing = context.config().getLong(MAX_LINES_PROPERTY).orElse(300000L);
        if (nLines > maxLinesForIndexing) {
            LOG.debug("Project symbol table deactivated due to project size (total number of lines is {}, maximum for indexing is {})", (Object)nLines, (Object)maxLinesForIndexing);
            LOG.debug("Update \"sonar.python.sonarlint.indexing.maxlines\" to set a different limit.");
            return;
        }
        LOG.debug("Input files for indexing: {}", files);
        PythonIndexer.GlobalSymbolsScanner globalSymbolsStep = new PythonIndexer.GlobalSymbolsScanner(context);
        globalSymbolsStep.execute(files, context);
    }

    @Override
    public void postAnalysis(SensorContext context) {
    }

    @Override
    public void setSonarLintCache(@Nullable SonarLintCache sonarLintCache) {
        if (sonarLintCache != null) {
            this.cacheContext = new CacheContextImpl(true, (PythonWriteCache)new PythonWriteCacheImpl((WriteCache)sonarLintCache), (PythonReadCache)new PythonReadCacheImpl((ReadCache)sonarLintCache));
        }
    }

    @Override
    public InputFile getFileWithId(String fileId) {
        String compare = fileId.replace("\\", "/");
        return this.indexedFiles.getOrDefault(compare, null);
    }

    @Override
    public CacheContext cacheContext() {
        return this.cacheContext != null ? this.cacheContext : CacheContextImpl.dummyCache();
    }

    private static List<PythonInputFile> getInputFiles(ModuleFileSystem moduleFileSystem) {
        ArrayList files = new ArrayList();
        moduleFileSystem.files("py", InputFile.Type.MAIN).map(PythonInputFileImpl::new).forEach(files::add);
        return Collections.unmodifiableList(files);
    }

    @Override
    void addFile(PythonInputFile inputFile) throws IOException {
        super.addFile(inputFile);
        this.indexedFiles.put(inputFile.wrappedFile().absolutePath(), inputFile.wrappedFile());
        this.recreateProjectLevelTypeTable();
    }

    @Override
    void removeFile(PythonInputFile inputFile) {
        super.removeFile(inputFile);
        this.indexedFiles.remove(inputFile.wrappedFile().absolutePath());
        this.recreateProjectLevelTypeTable();
    }

    public void process(ModuleFileEvent moduleFileEvent) {
        PythonInputFileImpl target = new PythonInputFileImpl(moduleFileEvent.getTarget());
        String language = target.wrappedFile().language();
        if (language == null || !language.equals("py")) {
            LOG.debug("Module file event for {} has been ignored because it's not a Python file.", (Object)target);
            return;
        }
        ModuleFileEvent.Type type = moduleFileEvent.getType();
        if (type.equals((Object)ModuleFileEvent.Type.DELETED) || type.equals((Object)ModuleFileEvent.Type.MODIFIED)) {
            this.removeFile((PythonInputFile)target);
        }
        if (type.equals((Object)ModuleFileEvent.Type.CREATED) || type.equals((Object)ModuleFileEvent.Type.MODIFIED)) {
            try {
                this.addFile((PythonInputFile)target);
            }
            catch (IOException e) {
                LOG.debug("Failed to load file \"{}\" ({}) to the project symbol table", (Object)target.wrappedFile().filename(), (Object)type);
            }
        }
    }
}

