/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.mypy;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.config.Configuration;
import org.sonar.plugins.python.ExternalIssuesSensor;
import org.sonar.plugins.python.TextReportReader;

public class MypySensor
extends ExternalIssuesSensor {
    private static final Logger LOG = LoggerFactory.getLogger(MypySensor.class);
    public static final String LINTER_NAME = "Mypy";
    public static final String LINTER_KEY = "mypy";
    public static final String REPORT_PATH_KEY = "sonar.python.mypy.reportPaths";
    private static final String FALLBACK_RULE_KEY = "unknown_mypy_rule";
    private static final String START_LOCATION = "(?<startLine>\\d+)(?::(?<startCol>\\d+))?";
    private static final String END_LOCATION = "(?::(?<endLine>\\d+):(?<endCol>\\d+))?";
    private static final Pattern PATTERN = Pattern.compile(String.format("^(?<file>[^:]+):%s%s: (?<severity>\\S+[^:]): (?<message>.*?)(?: \\[(?<code>.*)])?\\s*$", "(?<startLine>\\d+)(?::(?<startCol>\\d+))?", "(?::(?<endLine>\\d+):(?<endCol>\\d+))?"));

    @Override
    protected void importReport(File reportPath, SensorContext context, Set<String> unresolvedInputFiles) throws IOException {
        List<TextReportReader.Issue> issues = MypySensor.parse(reportPath, context.fileSystem());
        issues.forEach(i -> this.saveIssue(context, (TextReportReader.Issue)i, unresolvedInputFiles, LINTER_KEY));
    }

    private static List<TextReportReader.Issue> parse(File report, FileSystem fileSystem) throws IOException {
        ArrayList<TextReportReader.Issue> issues = new ArrayList<TextReportReader.Issue>();
        try (Scanner scanner = new Scanner(report.toPath(), fileSystem.encoding().name());){
            while (scanner.hasNextLine()) {
                TextReportReader.Issue issue = MypySensor.parseLine(scanner.nextLine());
                if (issue == null) continue;
                issues.add(issue);
            }
        }
        return issues;
    }

    private static TextReportReader.Issue parseLine(String line) {
        if (!line.isEmpty()) {
            Matcher m = PATTERN.matcher(line);
            if (m.matches()) {
                return MypySensor.extractIssue(m);
            }
            LOG.debug("Cannot parse the line: {}", (Object)line);
        }
        return null;
    }

    private static TextReportReader.Issue extractIssue(Matcher m) {
        String severity = m.group("severity");
        if (!"error".equals(severity)) {
            return null;
        }
        String filePath = m.group("file");
        int lineNumber = Integer.parseInt(m.group("startLine"));
        String message = m.group("message");
        String errorCode = m.group("code");
        if (errorCode == null) {
            errorCode = FALLBACK_RULE_KEY;
        }
        Integer columnNumber = Optional.ofNullable(m.group("startCol")).map(Integer::parseInt).map(i -> i - 1).orElse(null);
        Integer endLineNumber = Optional.ofNullable(m.group("endLine")).map(Integer::parseInt).orElse(null);
        Integer endColNumber = Optional.ofNullable(m.group("endCol")).map(Integer::parseInt).map(i -> i - 1).filter(i -> !i.equals(columnNumber)).orElse(null);
        return new TextReportReader.Issue(filePath, errorCode, message, lineNumber, columnNumber, endLineNumber, endColNumber);
    }

    @Override
    protected boolean shouldExecute(Configuration conf) {
        return conf.hasKey(REPORT_PATH_KEY);
    }

    @Override
    protected String linterName() {
        return LINTER_NAME;
    }

    @Override
    protected String reportPathKey() {
        return REPORT_PATH_KEY;
    }

    @Override
    protected Logger logger() {
        return LOG;
    }
}

