/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.indexer;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ProjectTree {
    public String name();

    @Nullable
    public ProjectTreeFolder parent();

    default public Stream<ProjectTreeFolder> parents() {
        return Stream.iterate(this.parent(), node -> node.parent() != null, ProjectTreeFolder::parent);
    }

    public Stream<ProjectTreeFolder> allFolders();

    public static final class ProjectTreeFolder
    implements ProjectTree {
        private final String name;
        private final List<ProjectTree> children;
        private ProjectTreeFolder parent;

        public ProjectTreeFolder(String name, List<ProjectTree> children) {
            this.name = name;
            this.children = List.copyOf(children);
            this.parent = null;
            for (ProjectTree child : this.children) {
                if (child instanceof ProjectTreeFile) {
                    ProjectTreeFile file = (ProjectTreeFile)child;
                    file.setParent(this);
                    continue;
                }
                if (!(child instanceof ProjectTreeFolder)) continue;
                ProjectTreeFolder folder = (ProjectTreeFolder)child;
                folder.setParent(this);
            }
        }

        @Override
        public String name() {
            return this.name;
        }

        public List<ProjectTree> children() {
            return this.children;
        }

        @Override
        @Nullable
        public ProjectTreeFolder parent() {
            return this.parent;
        }

        @Override
        public Stream<ProjectTreeFolder> allFolders() {
            return Stream.concat(Stream.of(this), this.children.stream().flatMap(ProjectTree::allFolders));
        }

        void setParent(ProjectTreeFolder parent) {
            this.parent = parent;
        }
    }

    public static final class ProjectTreeFile
    implements ProjectTree {
        private final String name;
        private ProjectTreeFolder parent;

        public ProjectTreeFile(String name) {
            this.name = name;
            this.parent = null;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        @Nullable
        public ProjectTreeFolder parent() {
            return this.parent;
        }

        @Override
        public Stream<ProjectTreeFolder> allFolders() {
            return Stream.empty();
        }

        void setParent(ProjectTreeFolder parent) {
            this.parent = parent;
        }
    }
}

