/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.nosonar;

import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.scan.issue.filter.IssueFilter;
import org.sonar.api.scan.issue.filter.IssueFilterChain;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.python.api.nosonar.NoSonarLineInfo;
import org.sonar.plugins.python.nosonar.NoSonarLineInfoCollector;
import org.sonarsource.api.sonarlint.SonarLintSide;

@SonarLintSide
@ScannerSide
public class NoSonarIssueFilter
implements IssueFilter {
    private static final Logger LOG = LoggerFactory.getLogger(NoSonarIssueFilter.class);
    private static final Set<String> WHITELISTED_RULES = Set.of("S1309", "NoSonar");
    private final NoSonarLineInfoCollector noSonarLineInfoCollector;

    public NoSonarIssueFilter(NoSonarLineInfoCollector noSonarLineInfoCollector) {
        this.noSonarLineInfoCollector = noSonarLineInfoCollector;
    }

    public boolean accept(FilterableIssue issue, IssueFilterChain chain) {
        boolean isNotFilteredOutByNoSonar;
        Integer issueLine = issue.line();
        if (issueLine == null) {
            return chain.accept(issue);
        }
        String issueComponentKey = issue.componentKey();
        Map<Integer, NoSonarLineInfo> noSonarLineInfos = this.noSonarLineInfoCollector.get(issueComponentKey);
        NoSonarLineInfo noSonarLineInfo = noSonarLineInfos.get(issueLine);
        String ruleId = issue.ruleKey().rule();
        if (WHITELISTED_RULES.contains(ruleId)) {
            LOG.debug("Rule {} cannot be filtered out as it is whitelisted (all whitelisted rules: {}) for component with key: {} on line: {}", new Object[]{ruleId, WHITELISTED_RULES, issueComponentKey, issueLine});
            return chain.accept(issue);
        }
        boolean bl = isNotFilteredOutByNoSonar = noSonarLineInfo == null || !noSonarLineInfo.isSuppressedRuleKeysEmpty() && !noSonarLineInfo.suppressedRuleKeys().contains(ruleId);
        if (!isNotFilteredOutByNoSonar) {
            LOG.debug("Filtering out issue in the component with key: {} for rule: {} on line: {} based on the file NoSonar infos {}", new Object[]{issueComponentKey, issue.ruleKey().rule(), issueLine, noSonarLineInfos.values()});
        }
        return isNotFilteredOutByNoSonar && chain.accept(issue);
    }
}

