/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.indexer;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.plugins.python.PythonInputFile;
import org.sonar.plugins.python.indexer.ProjectTree;

public class ProjectTreeBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectTreeBuilder.class);
    private final Map<ProjectPath, FolderNode> folderNodes = new HashMap<ProjectPath, FolderNode>();
    private final FolderNode rootNode = new FolderNode("/");

    public ProjectTree build(List<PythonInputFile> inputFiles) {
        for (PythonInputFile inputFile : inputFiles) {
            this.addFileToTree(inputFile);
        }
        return ProjectTreeBuilder.buildImmutableFolder(this.rootNode);
    }

    private void addFileToTree(PythonInputFile inputFile) {
        ProjectPath relativePath = ProjectTreeBuilder.extractRelativePath(inputFile);
        if (relativePath == null) {
            return;
        }
        this.getOrCreateFolder(relativePath);
    }

    private FolderNode getOrCreateFolder(ProjectPath path) {
        if (path.isEmpty()) {
            return this.rootNode;
        }
        if (this.folderNodes.containsKey(path)) {
            return this.folderNodes.get(path);
        }
        String fileName = path.fileName();
        if (fileName == null) {
            fileName = "";
        }
        FolderNode node = new FolderNode(fileName);
        this.folderNodes.put(path, node);
        FolderNode parent = this.getOrCreateFolder(path.parent());
        parent.children.add(node);
        return node;
    }

    private static ProjectTree buildImmutableFolder(FolderNode node) {
        ArrayList<ProjectTree> children = new ArrayList<ProjectTree>();
        for (FolderNode childNode : node.children) {
            children.add(ProjectTreeBuilder.buildImmutableFolder(childNode));
        }
        if (children.isEmpty()) {
            return new ProjectTree.ProjectTreeFile(node.name);
        }
        return new ProjectTree.ProjectTreeFolder(node.name, List.copyOf(children));
    }

    @CheckForNull
    private static ProjectPath extractRelativePath(PythonInputFile inputFile) {
        URI uri = inputFile.wrappedFile().uri();
        if (!"file".equalsIgnoreCase(uri.getScheme())) {
            LOG.debug("Skipping non-file URI: {}", (Object)uri);
            return null;
        }
        return ProjectPath.parse(uri.getSchemeSpecificPart());
    }

    private static class FolderNode {
        final String name;
        final List<FolderNode> children = new ArrayList<FolderNode>();

        FolderNode(String name) {
            this.name = name;
        }
    }

    private record ProjectPath(List<String> segments) {
        static ProjectPath parse(@Nullable String pathString) {
            if (pathString == null || pathString.isEmpty()) {
                return new ProjectPath(List.of());
            }
            String[] parts = pathString.split("[/\\\\]+");
            List<String> nonEmptySegments = Arrays.stream(parts).filter(part -> !part.isEmpty()).toList();
            return new ProjectPath(nonEmptySegments);
        }

        boolean isEmpty() {
            return this.segments.isEmpty();
        }

        @CheckForNull
        String fileName() {
            return this.isEmpty() ? null : this.segments.get(this.segments.size() - 1);
        }

        ProjectPath parent() {
            if (this.segments.size() <= 1) {
                return new ProjectPath(List.of());
            }
            return new ProjectPath(this.segments.subList(0, this.segments.size() - 1));
        }
    }
}

