/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.xunit;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.text.StringEscapeUtils;

public class TestCase {
    public static final String STATUS_OK = "ok";
    public static final String STATUS_ERROR = "error";
    public static final String STATUS_FAILURE = "failure";
    public static final String STATUS_SKIPPED = "skipped";
    private final String name;
    private final String status;
    private final String stackTrace;
    private final String errorMessage;
    private final int time;
    private final String file;
    private final String testClassname;

    public TestCase(String name, int time, String status, String stack, String msg, @Nullable String file, @Nullable String testClassname) {
        this.name = name;
        this.time = time;
        this.stackTrace = stack;
        this.errorMessage = msg;
        this.status = status;
        this.file = file;
        this.testClassname = testClassname;
    }

    public boolean isError() {
        return STATUS_ERROR.equals(this.status);
    }

    public boolean isFailure() {
        return STATUS_FAILURE.equals(this.status);
    }

    public boolean isSkipped() {
        return STATUS_SKIPPED.equals(this.status);
    }

    public int getTime() {
        return this.time;
    }

    @CheckForNull
    public String getFile() {
        return this.file;
    }

    @CheckForNull
    public String getTestClassname() {
        return this.testClassname;
    }

    public String getDetails() {
        StringBuilder details = new StringBuilder();
        details.append("<testcase status=\"").append(this.status).append("\" time=\"").append(this.time).append("\" name=\"").append(this.name).append("\"");
        if (this.isError() || this.isFailure()) {
            details.append(">").append(this.isError() ? "<error message=\"" : "<failure message=\"").append(StringEscapeUtils.escapeXml11((String)this.errorMessage)).append("\">").append("<![CDATA[").append(StringEscapeUtils.escapeXml11((String)this.stackTrace)).append("]]>").append(this.isError() ? "</error>" : "</failure>").append("</testcase>");
        } else {
            details.append("/>");
        }
        return details.toString();
    }
}

