/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.concurrent.locks.Lock;
import org.sonar.api.batch.sensor.symbol.NewSymbol;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonar.plugins.python.api.symbols.Symbol;
import org.sonar.plugins.python.api.symbols.Usage;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.DictCompExpression;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.Tree;

public class NewSymbolsCollector {
    private final Lock lock;

    public NewSymbolsCollector(Lock lock) {
        this.lock = lock;
    }

    public void collect(NewSymbolTable newSymbolTable, FileInput fileInput) {
        SymbolsCollectingVisitor visitor = new SymbolsCollectingVisitor(newSymbolTable);
        visitor.visitFileInput(fileInput);
        this.save(newSymbolTable);
    }

    private void save(NewSymbolTable newSymbolTable) {
        try {
            this.lock.lock();
            newSymbolTable.save();
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class SymbolsCollectingVisitor
    extends BaseTreeVisitor {
        private final NewSymbolTable newSymbolTable;

        public SymbolsCollectingVisitor(NewSymbolTable newSymbolTable) {
            this.newSymbolTable = newSymbolTable;
        }

        public void visitClassDef(ClassDef classDef) {
            classDef.classFields().forEach(this::handleSymbol);
            classDef.instanceFields().forEach(this::handleSymbol);
            super.visitClassDef(classDef);
        }

        public void visitFunctionDef(FunctionDef functionDef) {
            functionDef.localVariables().forEach(this::handleSymbol);
            super.visitFunctionDef(functionDef);
        }

        public void visitLambda(LambdaExpression lambdaExpression) {
            lambdaExpression.localVariables().forEach(this::handleSymbol);
            super.visitLambda(lambdaExpression);
        }

        public void visitPyListOrSetCompExpression(ComprehensionExpression tree) {
            tree.localVariables().forEach(this::handleSymbol);
            super.visitPyListOrSetCompExpression(tree);
        }

        public void visitDictCompExpression(DictCompExpression tree) {
            tree.localVariables().forEach(this::handleSymbol);
            super.visitDictCompExpression(tree);
        }

        public void visitFileInput(FileInput fileInput) {
            fileInput.globalVariables().forEach(this::handleSymbol);
            super.visitFileInput(fileInput);
        }

        private void handleSymbol(Symbol symbol) {
            if (symbol.usages().isEmpty()) {
                return;
            }
            ArrayList<Usage> usages = new ArrayList<Usage>(symbol.usages());
            usages.sort(Comparator.comparingInt(u -> u.tree().firstToken().line()));
            Tree firstUsageTree = ((Usage)usages.get(0)).tree();
            NewSymbol newSymbol = this.newSymbolTable.newSymbol(firstUsageTree.firstToken().line(), firstUsageTree.firstToken().column(), firstUsageTree.lastToken().line(), firstUsageTree.lastToken().column() + firstUsageTree.lastToken().value().length());
            for (int i = 1; i < usages.size(); ++i) {
                Tree usageTree = ((Usage)usages.get(i)).tree();
                newSymbol.newReference(usageTree.firstToken().line(), usageTree.firstToken().column(), usageTree.lastToken().line(), usageTree.lastToken().column() + usageTree.lastToken().value().length());
            }
        }
    }
}

