/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Checks;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonCustomRuleRepository;
import org.sonar.plugins.python.api.internal.EndOfAnalysis;

public class PythonChecks {
    private static final Set<String> SONAR_PYTHON_REPOSITORIES = Set.of("python", "pythonenterprise", "ipython", "ipythonenterprise");
    private final CheckFactory checkFactory;
    private final Map<String, RepositoryChecksInfo> sonarPythonRepositoriesChecks;
    private final Map<String, Checks<PythonCheck>> noSonarPythonRepositoriesChecks;
    private final Map<Class<? extends PythonCheck>, RuleKey> ruleKeys;

    PythonChecks(CheckFactory checkFactory) {
        this.checkFactory = checkFactory;
        this.sonarPythonRepositoriesChecks = new ConcurrentHashMap<String, RepositoryChecksInfo>();
        this.noSonarPythonRepositoriesChecks = new ConcurrentHashMap<String, Checks<PythonCheck>>();
        this.ruleKeys = new ConcurrentHashMap<Class<? extends PythonCheck>, RuleKey>();
    }

    public PythonChecks addChecks(String repositoryKey, Iterable<Class<?>> checkClasses) {
        RepositoryChecksInfo repositoryChecksInfo = new RepositoryChecksInfo(repositoryKey, checkClasses);
        Checks<PythonCheck> checks = this.createChecks(repositoryChecksInfo);
        checks.all().forEach(check -> {
            Class checkClass = check.getClass();
            RuleKey ruleKey = checks.ruleKey(check);
            this.ruleKeys.put(checkClass, ruleKey);
        });
        if (SONAR_PYTHON_REPOSITORIES.contains(repositoryKey)) {
            this.sonarPythonRepositoriesChecks.put(repositoryChecksInfo.repositoryKey, repositoryChecksInfo);
        } else {
            this.noSonarPythonRepositoriesChecks.put(repositoryChecksInfo.repositoryKey, this.createChecks(repositoryChecksInfo));
        }
        return this;
    }

    public PythonChecks addCustomChecks(@Nullable PythonCustomRuleRepository[] customRuleRepositories) {
        Stream.ofNullable(customRuleRepositories).flatMap(Stream::of).forEach(ruleRepository -> this.addChecks(ruleRepository.repositoryKey(), ruleRepository.checkClasses()));
        return this;
    }

    public synchronized List<PythonCheck> sonarPythonChecks() {
        return this.sonarPythonRepositoriesChecks.values().stream().map(this::createChecks).map(Checks::all).flatMap(Collection::stream).toList();
    }

    public synchronized Map<String, List<PythonCheck>> noSonarPythonChecks() {
        return this.noSonarPythonRepositoriesChecks.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Checks)entry.getValue()).all().stream().toList()));
    }

    public List<EndOfAnalysis> sonarPythonEndOfAnalyses() {
        return this.sonarPythonChecks().stream().filter(EndOfAnalysis.class::isInstance).map(EndOfAnalysis.class::cast).toList();
    }

    public Map<String, List<EndOfAnalysis>> noSonarPythonEndOfAnalyses() {
        return this.noSonarPythonChecks().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().filter(EndOfAnalysis.class::isInstance).map(EndOfAnalysis.class::cast).toList()));
    }

    @Nullable
    public RuleKey ruleKey(PythonCheck check) {
        return this.ruleKeys.getOrDefault(check.getClass(), null);
    }

    private Checks<PythonCheck> createChecks(RepositoryChecksInfo repositoryChecksInfo) {
        return this.checkFactory.create(repositoryChecksInfo.repositoryKey).addAnnotatedChecks(repositoryChecksInfo.checkClasses);
    }

    private record RepositoryChecksInfo(String repositoryKey, Iterable<Class<?>> checkClasses) {
    }
}

