/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.cpd;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.TokenLocation;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.caching.CpdSerializer;
import org.sonar.python.tree.TreeUtils;

public class PythonCpdAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(PythonCpdAnalyzer.class);
    private final SensorContext context;
    private final Lock lock;

    public PythonCpdAnalyzer(SensorContext context, Lock lock) {
        this.context = context;
        this.lock = lock;
    }

    public void pushCpdTokens(InputFile inputFile, PythonVisitorContext visitorContext) {
        FileInput root = visitorContext.rootTree();
        if (root != null) {
            NewCpdTokens cpdTokens = this.context.newCpdTokens().onFile(inputFile);
            List tokens = TreeUtils.tokens((Tree)root);
            ArrayList<Token> tokensToCache = new ArrayList<Token>();
            for (int i = 0; i < tokens.size(); ++i) {
                GenericTokenType nextTokenType;
                Token token = (Token)tokens.get(i);
                TokenType currentTokenType = token.type();
                Object object = nextTokenType = i + 1 < tokens.size() ? ((Token)tokens.get(i + 1)).type() : GenericTokenType.EOF;
                if (!PythonCpdAnalyzer.isNewLineWithIndentationChange(currentTokenType, (TokenType)nextTokenType) && PythonCpdAnalyzer.isIgnoredType(currentTokenType)) continue;
                TokenLocation location = new TokenLocation(token);
                cpdTokens.addToken(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset(), token.value());
                tokensToCache.add(token);
            }
            this.saveTokensToCache(visitorContext, tokensToCache);
            this.save(cpdTokens);
        }
    }

    public boolean pushCachedCpdTokens(InputFile inputFile, CacheContext cacheContext) {
        String dataKey = PythonCpdAnalyzer.dataCacheKey(inputFile.key());
        String tableKey = PythonCpdAnalyzer.stringTableCacheKey(inputFile.key());
        byte[] dataBytes = cacheContext.getReadCache().readBytes(dataKey);
        byte[] tableBytes = cacheContext.getReadCache().readBytes(tableKey);
        if (dataBytes == null || tableBytes == null) {
            return false;
        }
        try {
            List tokens = CpdSerializer.deserialize((byte[])dataBytes, (byte[])tableBytes);
            NewCpdTokens cpdTokens = this.context.newCpdTokens().onFile(inputFile);
            tokens.forEach(tokenInfo -> cpdTokens.addToken(tokenInfo.startLine, tokenInfo.startLineOffset, tokenInfo.endLine, tokenInfo.endLineOffset, tokenInfo.value));
            this.save(cpdTokens);
            this.copyFromPrevious(cacheContext, dataKey, tableKey);
            return true;
        }
        catch (IOException e) {
            LOG.warn("Failed to deserialize CPD tokens ({}: {})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return false;
        }
    }

    private void saveTokensToCache(PythonVisitorContext visitorContext, List<Token> tokensToCache) {
        CacheContext cacheContext = visitorContext.cacheContext();
        if (!cacheContext.isCacheEnabled()) {
            return;
        }
        try {
            String fileKey = visitorContext.pythonFile().key();
            CpdSerializer.SerializationResult result = CpdSerializer.serialize(tokensToCache);
            this.writeToCache(cacheContext, fileKey, result);
        }
        catch (Exception e) {
            LOG.warn("Could not write CPD tokens to cache ({}: {})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    private void save(NewCpdTokens cpdTokens) {
        try {
            this.lock.lock();
            cpdTokens.save();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFromPrevious(CacheContext cacheContext, String dataKey, String tableKey) {
        try {
            this.lock.lock();
            cacheContext.getWriteCache().copyFromPrevious(dataKey);
            cacheContext.getWriteCache().copyFromPrevious(tableKey);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToCache(CacheContext cacheContext, String fileKey, CpdSerializer.SerializationResult result) {
        try {
            this.lock.lock();
            cacheContext.getWriteCache().write(PythonCpdAnalyzer.stringTableCacheKey(fileKey), result.stringTable);
            cacheContext.getWriteCache().write(PythonCpdAnalyzer.dataCacheKey(fileKey), result.data);
        }
        finally {
            this.lock.unlock();
        }
    }

    private static boolean isNewLineWithIndentationChange(TokenType currentTokenType, TokenType nextTokenType) {
        return currentTokenType.equals((Object)PythonTokenType.NEWLINE) && nextTokenType.equals((Object)PythonTokenType.DEDENT);
    }

    private static boolean isIgnoredType(TokenType type) {
        return type.equals((Object)PythonTokenType.NEWLINE) || type.equals((Object)PythonTokenType.DEDENT) || type.equals((Object)PythonTokenType.INDENT) || type.equals((Object)GenericTokenType.EOF);
    }

    private static String dataCacheKey(String fileKey) {
        return "python:cpd:data:" + fileKey.replace('\\', '/');
    }

    private static String stringTableCacheKey(String fileKey) {
        return "python:cpd:stringTable:" + fileKey.replace('\\', '/');
    }
}

