/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.dependency;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.python.dependency.DependencyPostProcessor;
import org.sonar.plugins.python.dependency.PyProjectTomlParser;
import org.sonar.plugins.python.dependency.RequirementsTxtParser;
import org.sonar.plugins.python.dependency.model.Dependencies;
import org.sonar.plugins.python.dependency.model.Dependency;
import org.sonar.plugins.python.telemetry.SensorTelemetryStorage;
import org.sonar.plugins.python.telemetry.TelemetryMetricKey;

public class DependencyTelemetry {
    private static final String TELEMETRY_FORMAT_VERSION = "1";
    private final SensorTelemetryStorage sensorTelemetryStorage;
    private final FileSystem fileSystem;

    public DependencyTelemetry(SensorTelemetryStorage sensorTelemetryStorage, FileSystem fileSystem) {
        this.sensorTelemetryStorage = sensorTelemetryStorage;
        this.fileSystem = fileSystem;
    }

    public void process() {
        Dependencies dependencies = this.collectDependencies();
        Dependencies postProcessedDependencies = DependencyPostProcessor.process(dependencies);
        this.updateDependenciesTelemetryMetrics(postProcessedDependencies);
    }

    private Dependencies collectDependencies() {
        return Stream.concat(this.collectRequirementsTxtDependencies(), this.collectPyProjectTomlDependencies()).collect(Dependencies.mergeCollector());
    }

    private Stream<Dependencies> collectRequirementsTxtDependencies() {
        List<InputFile> requirementsTxtFiles = this.collectInputFiles("requirements.txt");
        return requirementsTxtFiles.stream().map(RequirementsTxtParser::parseRequirementFile);
    }

    private Stream<Dependencies> collectPyProjectTomlDependencies() {
        List<InputFile> pyProjectTomlFiles = this.collectInputFiles("pyproject.toml");
        return pyProjectTomlFiles.stream().map(PyProjectTomlParser::parse);
    }

    private List<InputFile> collectInputFiles(String fileName) {
        ArrayList<InputFile> list = new ArrayList<InputFile>();
        this.fileSystem.inputFiles(this.fileSystem.predicates().hasFilename(fileName)).forEach(list::add);
        return list;
    }

    private void updateDependenciesTelemetryMetrics(Dependencies dependencies) {
        String dependenciesString = DependencyTelemetry.formatDependencies(dependencies);
        this.sensorTelemetryStorage.updateMetric(TelemetryMetricKey.PYTHON_DEPENDENCIES, dependenciesString);
        this.sensorTelemetryStorage.updateMetric(TelemetryMetricKey.PYTHON_DEPENDENCIES_FORMAT_VERSION, TELEMETRY_FORMAT_VERSION);
    }

    private static String formatDependencies(Dependencies dependencies) {
        return dependencies.dependencies().stream().map(Dependency::name).collect(Collectors.joining(","));
    }
}

