/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.ruff;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONObject;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.JSONParser;
import org.sonarsource.analyzer.commons.internal.json.simple.parser.ParseException;

public class RuffJsonReportReader {
    private final Consumer<Issue> consumer;
    private final JSONParser jsonParser;

    private RuffJsonReportReader(Consumer<Issue> consumer) {
        this.consumer = consumer;
        this.jsonParser = new JSONParser();
    }

    static void read(InputStream in, Consumer<Issue> consumer) throws IOException, ParseException {
        new RuffJsonReportReader(consumer).read(in);
    }

    private void read(InputStream in) throws IOException, ParseException {
        JSONArray files = (JSONArray)this.jsonParser.parse((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        if (files != null) {
            files.stream().forEach(this::onResult);
        }
    }

    private void onResult(JSONObject result) {
        Issue issue = new Issue();
        issue.ruleKey = (String)result.get((Object)"code");
        issue.filePath = (String)result.get((Object)"filename");
        issue.message = (String)result.get((Object)"message");
        JSONObject location = (JSONObject)result.get((Object)"location");
        issue.startLocationCol = RuffJsonReportReader.toInteger(location.get((Object)"column"));
        issue.startLocationRow = RuffJsonReportReader.toInteger(location.get((Object)"row"));
        JSONObject endLocation = (JSONObject)result.get((Object)"end_location");
        issue.endLocationRow = RuffJsonReportReader.toInteger(endLocation.get((Object)"row"));
        issue.endLocationCol = RuffJsonReportReader.correctEndLocationCol(endLocation.get((Object)"column"), issue.startLocationCol, issue.startLocationRow, issue.endLocationRow);
        this.consumer.accept(issue);
    }

    private static Integer correctEndLocationCol(Object value, int startLocationCol, int startLocationRow, int endLocationRow) {
        Integer endLocationCol = RuffJsonReportReader.toInteger(value);
        if (endLocationCol != null) {
            if (endLocationRow == startLocationRow && endLocationCol <= startLocationCol) {
                return startLocationCol;
            }
            return endLocationCol - 1;
        }
        return null;
    }

    private static Integer toInteger(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        return null;
    }

    public static class Issue {
        @Nullable
        String ruleKey;
        @Nullable
        String filePath;
        @Nullable
        String message;
        @Nullable
        Integer startLocationRow;
        @Nullable
        Integer startLocationCol;
        @Nullable
        Integer endLocationRow;
        @Nullable
        Integer endLocationCol;
    }
}

