/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.telemetry.collectors;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.AssertStatement;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.telemetry.collectors.TestFileTelemetry;

public class TestFileTelemetryCollector {
    private static final Set<String> TEST_FRAMEWORK_MODULES = Set.of("unittest", "pytest");
    private final AtomicLong totalMainFiles = new AtomicLong(0L);
    private final AtomicLong misclassifiedTestFiles = new AtomicLong(0L);

    public void collect(FileInput rootTree, InputFile.Type fileType) {
        if (fileType != InputFile.Type.MAIN) {
            return;
        }
        this.totalMainFiles.incrementAndGet();
        TestImportVisitor importVisitor = new TestImportVisitor();
        rootTree.accept((TreeVisitor)importVisitor);
        if (importVisitor.hasTestFrameworkImport) {
            this.misclassifiedTestFiles.incrementAndGet();
            return;
        }
        PytestPatternVisitor pytestPatternVisitor = new PytestPatternVisitor();
        rootTree.accept((TreeVisitor)pytestPatternVisitor);
        if (pytestPatternVisitor.hasPytestPattern) {
            this.misclassifiedTestFiles.incrementAndGet();
        }
    }

    public TestFileTelemetry getTelemetry() {
        return new TestFileTelemetry(this.totalMainFiles.get(), this.misclassifiedTestFiles.get());
    }

    private static class TestImportVisitor
    extends BaseTreeVisitor {
        boolean hasTestFrameworkImport = false;

        private TestImportVisitor() {
        }

        public void visitImportName(ImportName importName) {
            if (this.hasTestFrameworkImport) {
                return;
            }
            for (AliasedName aliasedName : importName.modules()) {
                String moduleName;
                List names = aliasedName.dottedName().names();
                if (names.isEmpty() || !TEST_FRAMEWORK_MODULES.contains(moduleName = ((Name)names.get(0)).name())) continue;
                this.hasTestFrameworkImport = true;
                return;
            }
            super.visitImportName(importName);
        }

        public void visitImportFrom(ImportFrom importFrom) {
            String rootModule;
            List names;
            if (this.hasTestFrameworkImport) {
                return;
            }
            DottedName moduleName = importFrom.module();
            if (moduleName != null && !(names = moduleName.names()).isEmpty() && TEST_FRAMEWORK_MODULES.contains(rootModule = ((Name)names.get(0)).name())) {
                this.hasTestFrameworkImport = true;
                return;
            }
            super.visitImportFrom(importFrom);
        }
    }

    private static class PytestPatternVisitor
    extends BaseTreeVisitor {
        boolean hasPytestPattern = false;

        private PytestPatternVisitor() {
        }

        public void visitFunctionDef(FunctionDef functionDef) {
            if (this.hasPytestPattern) {
                return;
            }
            String functionName = functionDef.name().name();
            if (functionName.startsWith("test_") && PytestPatternVisitor.containsAssert(functionDef)) {
                this.hasPytestPattern = true;
                return;
            }
            super.visitFunctionDef(functionDef);
        }

        private static boolean containsAssert(FunctionDef functionDef) {
            AssertStatementVisitor assertVisitor = new AssertStatementVisitor();
            functionDef.body().accept((TreeVisitor)assertVisitor);
            return assertVisitor.hasAssert;
        }
    }

    private static class AssertStatementVisitor
    extends BaseTreeVisitor {
        boolean hasAssert = false;

        private AssertStatementVisitor() {
        }

        public void visitAssertStatement(AssertStatement assertStatement) {
            this.hasAssert = true;
        }
    }
}

