/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.indexer;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.plugins.python.indexer.NamespacePackageTelemetry;
import org.sonar.plugins.python.indexer.ProjectTree;

public class NamespacePackageAnalyzer {
    public NamespacePackageTelemetry analyze(ProjectTree projectTree) {
        List<ProjectTree.ProjectTreeFolder> foldersWithPythonFiles = projectTree.allFolders().filter(folder -> !"/".equals(folder.name())).filter(NamespacePackageAnalyzer::hasPythonFiles).toList();
        int packagesWithInit = 0;
        int packagesWithoutInit = 0;
        int duplicatePackagesWithoutInit = 0;
        int namespacePackagesInRegularPackage = 0;
        Map<String, Long> folderNameCounts = foldersWithPythonFiles.stream().collect(Collectors.groupingBy(ProjectTree.ProjectTreeFolder::name, Collectors.counting()));
        for (ProjectTree.ProjectTreeFolder folder2 : foldersWithPythonFiles) {
            boolean appearMultipleTimes;
            if (NamespacePackageAnalyzer.hasInitFile(folder2)) {
                ++packagesWithInit;
                continue;
            }
            ++packagesWithoutInit;
            boolean bl = appearMultipleTimes = folderNameCounts.get(folder2.name()) > 1L;
            if (appearMultipleTimes) {
                ++duplicatePackagesWithoutInit;
            }
            if (!NamespacePackageAnalyzer.hasAnyParentWithInit(folder2)) continue;
            ++namespacePackagesInRegularPackage;
        }
        return new NamespacePackageTelemetry(packagesWithInit, packagesWithoutInit, duplicatePackagesWithoutInit, namespacePackagesInRegularPackage);
    }

    private static boolean hasAnyParentWithInit(ProjectTree.ProjectTreeFolder folder) {
        return folder.parents().anyMatch(NamespacePackageAnalyzer::hasInitFile);
    }

    private static boolean hasInitFile(ProjectTree.ProjectTreeFolder folder) {
        return folder.children().stream().anyMatch(child -> child instanceof ProjectTree.ProjectTreeFile && "__init__.py".equals(child.name()));
    }

    private static boolean hasPythonFiles(ProjectTree.ProjectTreeFolder folder) {
        return folder.children().stream().anyMatch(child -> child instanceof ProjectTree.ProjectTreeFile && child.name().endsWith(".py"));
    }
}

