/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.telemetry.collectors;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.sonar.plugins.python.api.symbols.v2.SymbolV2;
import org.sonar.plugins.python.api.symbols.v2.UsageV2;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.BaseTreeVisitor;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.types.v2.PythonType;
import org.sonar.plugins.python.api.types.v2.UnknownType;
import org.sonar.plugins.python.telemetry.collectors.TypeInferenceTelemetry;

public class TypeInferenceTelemetryCollector {
    private final AtomicLong totalNames = new AtomicLong(0L);
    private final AtomicLong unknownTypeNames = new AtomicLong(0L);
    private final AtomicLong unresolvedImportTypeNames = new AtomicLong(0L);
    private final AtomicLong totalImports = new AtomicLong(0L);
    private final AtomicLong importsWithUnknownType = new AtomicLong(0L);
    private final AtomicLong uniqueSymbols = new AtomicLong(0L);
    private final AtomicLong unknownSymbols = new AtomicLong(0L);

    public void collect(FileInput rootTree) {
        CollectorVisitor visitor = new CollectorVisitor();
        rootTree.accept((TreeVisitor)visitor);
        this.aggregateMetrics(visitor);
    }

    private synchronized void aggregateMetrics(CollectorVisitor visitor) {
        this.totalNames.addAndGet(visitor.totalNames);
        this.unknownTypeNames.addAndGet(visitor.unknownTypeNames);
        this.unresolvedImportTypeNames.addAndGet(visitor.unresolvedImportTypeNames);
        this.totalImports.addAndGet(visitor.totalImports);
        this.importsWithUnknownType.addAndGet(visitor.importsWithUnknownType);
        this.uniqueSymbols.addAndGet(visitor.uniqueSymbols.size());
        this.unknownSymbols.addAndGet(visitor.unknownSymbols.size());
    }

    public TypeInferenceTelemetry getTelemetry() {
        return new TypeInferenceTelemetry(this.totalNames.get(), this.unknownTypeNames.get(), this.unresolvedImportTypeNames.get(), this.totalImports.get(), this.importsWithUnknownType.get(), this.uniqueSymbols.get(), this.unknownSymbols.get());
    }

    private static class CollectorVisitor
    extends BaseTreeVisitor {
        long totalNames = 0L;
        long unknownTypeNames = 0L;
        long unresolvedImportTypeNames = 0L;
        long totalImports = 0L;
        long importsWithUnknownType = 0L;
        Set<SymbolV2> uniqueSymbols = new HashSet<SymbolV2>();
        Set<SymbolV2> unknownSymbols = new HashSet<SymbolV2>();

        private CollectorVisitor() {
        }

        public void visitName(Name name) {
            ++this.totalNames;
            PythonType type = name.typeV2();
            if (type == PythonType.UNKNOWN) {
                ++this.unknownTypeNames;
            } else if (type instanceof UnknownType.UnresolvedImportType) {
                ++this.unresolvedImportTypeNames;
            }
            SymbolV2 symbol = name.symbolV2();
            if (symbol != null) {
                this.uniqueSymbols.add(symbol);
                if (CollectorVisitor.isUnknownSymbol(symbol)) {
                    this.unknownSymbols.add(symbol);
                }
            }
            super.visitName(name);
        }

        public void visitImportName(ImportName importName) {
            for (AliasedName aliasedName : importName.modules()) {
                ++this.totalImports;
                if (!CollectorVisitor.hasUnknownImportType(aliasedName)) continue;
                ++this.importsWithUnknownType;
            }
            super.visitImportName(importName);
        }

        public void visitImportFrom(ImportFrom importFrom) {
            for (AliasedName aliasedName : importFrom.importedNames()) {
                ++this.totalImports;
                if (!CollectorVisitor.hasUnknownImportType(aliasedName)) continue;
                ++this.importsWithUnknownType;
            }
            super.visitImportFrom(importFrom);
        }

        private static boolean hasUnknownImportType(AliasedName aliasedName) {
            List names;
            Name nameToCheck = aliasedName.alias();
            if (nameToCheck == null && !(names = aliasedName.dottedName().names()).isEmpty()) {
                nameToCheck = (Name)names.get(names.size() - 1);
            }
            if (nameToCheck == null) {
                return false;
            }
            return CollectorVisitor.isUnknownType(nameToCheck.typeV2());
        }

        private static boolean isUnknownType(PythonType type) {
            return type == PythonType.UNKNOWN || type instanceof UnknownType.UnresolvedImportType;
        }

        private static boolean isUnknownSymbol(SymbolV2 symbol) {
            return symbol.usages().stream().filter(UsageV2::isBindingUsage).allMatch(usage -> {
                Tree patt0$temp = usage.tree();
                if (patt0$temp instanceof Name) {
                    Name name = (Name)patt0$temp;
                    return CollectorVisitor.isUnknownType(name.typeV2());
                }
                return true;
            });
        }
    }
}

