/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.cpd;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.TokenLocation;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.api.PythonTokenType;
import org.sonar.python.caching.CpdSerializer;
import org.sonar.python.tree.TreeUtils;

public class PythonCpdAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger(PythonCpdAnalyzer.class);
    private final SensorContext context;

    public PythonCpdAnalyzer(SensorContext context) {
        this.context = context;
    }

    public void pushCpdTokens(InputFile inputFile, PythonVisitorContext visitorContext) {
        FileInput root = visitorContext.rootTree();
        if (root != null) {
            NewCpdTokens cpdTokens = this.context.newCpdTokens().onFile(inputFile);
            List tokens = TreeUtils.tokens((Tree)root);
            ArrayList<Token> tokensToCache = new ArrayList<Token>();
            for (int i = 0; i < tokens.size(); ++i) {
                GenericTokenType nextTokenType;
                Token token = (Token)tokens.get(i);
                TokenType currentTokenType = token.type();
                Object object = nextTokenType = i + 1 < tokens.size() ? ((Token)tokens.get(i + 1)).type() : GenericTokenType.EOF;
                if (!PythonCpdAnalyzer.isNewLineWithIndentationChange(currentTokenType, (TokenType)nextTokenType) && PythonCpdAnalyzer.isIgnoredType(currentTokenType)) continue;
                TokenLocation location = new TokenLocation(token);
                cpdTokens.addToken(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset(), token.value());
                tokensToCache.add(token);
            }
            PythonCpdAnalyzer.saveTokensToCache(visitorContext, tokensToCache);
            cpdTokens.save();
        }
    }

    public boolean pushCachedCpdTokens(InputFile inputFile, CacheContext cacheContext) {
        String dataKey = PythonCpdAnalyzer.dataCacheKey(inputFile.key());
        String tableKey = PythonCpdAnalyzer.stringTableCacheKey(inputFile.key());
        byte[] dataBytes = cacheContext.getReadCache().readBytes(dataKey);
        byte[] tableBytes = cacheContext.getReadCache().readBytes(tableKey);
        if (dataBytes == null || tableBytes == null) {
            return false;
        }
        try {
            List tokens = CpdSerializer.deserialize((byte[])dataBytes, (byte[])tableBytes);
            NewCpdTokens cpdTokens = this.context.newCpdTokens().onFile(inputFile);
            tokens.forEach(tokenInfo -> cpdTokens.addToken(tokenInfo.startLine, tokenInfo.startLineOffset, tokenInfo.endLine, tokenInfo.endLineOffset, tokenInfo.value));
            cpdTokens.save();
            cacheContext.getWriteCache().copyFromPrevious(dataKey);
            cacheContext.getWriteCache().copyFromPrevious(tableKey);
            return true;
        }
        catch (IOException e) {
            LOG.warn("Failed to deserialize CPD tokens ({}: {})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            return false;
        }
    }

    private static void saveTokensToCache(PythonVisitorContext visitorContext, List<Token> tokensToCache) {
        CacheContext cacheContext = visitorContext.cacheContext();
        if (!cacheContext.isCacheEnabled()) {
            return;
        }
        try {
            String fileKey = visitorContext.pythonFile().key();
            CpdSerializer.SerializationResult result = CpdSerializer.serialize(tokensToCache);
            cacheContext.getWriteCache().write(PythonCpdAnalyzer.stringTableCacheKey(fileKey), result.stringTable);
            cacheContext.getWriteCache().write(PythonCpdAnalyzer.dataCacheKey(fileKey), result.data);
        }
        catch (Exception e) {
            LOG.warn("Could not write CPD tokens to cache ({}: {})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    private static boolean isNewLineWithIndentationChange(TokenType currentTokenType, TokenType nextTokenType) {
        return currentTokenType.equals(PythonTokenType.NEWLINE) && nextTokenType.equals(PythonTokenType.DEDENT);
    }

    private static boolean isIgnoredType(TokenType type) {
        return type.equals(PythonTokenType.NEWLINE) || type.equals(PythonTokenType.DEDENT) || type.equals(PythonTokenType.INDENT) || type.equals(GenericTokenType.EOF);
    }

    private static String dataCacheKey(String fileKey) {
        return "python:cpd:data:" + fileKey.replace('\\', '/');
    }

    private static String stringTableCacheKey(String fileKey) {
        return "python:cpd:stringTable:" + fileKey.replace('\\', '/');
    }
}

