/*
 * SonarQube Python Plugin
 * Copyright (C) 2011-2025 SonarSource SA
 * mailto:info AT sonarsource DOT com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Sonar Source-Available License Version 1, as published by SonarSource SA.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the Sonar Source-Available License for more details.
 *
 * You should have received a copy of the Sonar Source-Available License
 * along with this program; if not, see https://sonarsource.com/license/ssal/
 */
package org.sonar.plugins.python.dependency.model;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public record Dependencies(Set<Dependency> dependencies) {
  public Dependencies(Set<Dependency> dependencies) {
    this.dependencies = Collections.unmodifiableSet(dependencies);
  }

  public static Collector<Dependencies, ?, Dependencies> mergeCollector() {
    return Collectors.collectingAndThen(
      Collectors.flatMapping((Dependencies dependencies) -> dependencies.dependencies().stream(), Collectors.toSet()),
      Dependencies::new
    );
  }
}
