/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.SonarProduct;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.fix.NewInputFileEdit;
import org.sonar.api.batch.sensor.issue.fix.NewQuickFix;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.Metric;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugins.python.GeneratedIPythonFile;
import org.sonar.plugins.python.PythonChecks;
import org.sonar.plugins.python.PythonHighlighter;
import org.sonar.plugins.python.PythonInputFile;
import org.sonar.plugins.python.PythonInputFileImpl;
import org.sonar.plugins.python.Scanner;
import org.sonar.plugins.python.SonarQubePythonFile;
import org.sonar.plugins.python.SymbolVisitor;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.PythonFileConsumer;
import org.sonar.plugins.python.api.PythonInputFileContext;
import org.sonar.plugins.python.api.PythonSubscriptionCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.internal.EndOfAnalysis;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.cpd.PythonCpdAnalyzer;
import org.sonar.plugins.python.indexer.PythonIndexer;
import org.sonar.python.IPythonLocation;
import org.sonar.python.SubscriptionVisitor;
import org.sonar.python.metrics.FileLinesVisitor;
import org.sonar.python.metrics.FileMetrics;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.tree.IPythonTreeMaker;
import org.sonar.python.tree.PythonTreeMaker;

public class PythonScanner
extends Scanner {
    private static final Logger LOG = LoggerFactory.getLogger(PythonScanner.class);
    private final Supplier<PythonParser> parserSupplier;
    private final PythonChecks checks;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private final PythonCpdAnalyzer cpdAnalyzer;
    private final PythonIndexer indexer;
    private final Map<PythonInputFile, Set<PythonCheck>> checksExecutedWithoutParsingByFiles = new HashMap<PythonInputFile, Set<PythonCheck>>();
    private int recognitionErrorCount = 0;
    private static final Pattern DATABRICKS_MAGIC_COMMAND_PATTERN = Pattern.compile("^\\h*#\\h*(MAGIC|COMMAND).*");
    private boolean foundDatabricks = false;
    private final PythonFileConsumer architectureCallback;

    public PythonScanner(SensorContext context, PythonChecks checks, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, Supplier<PythonParser> parserSupplier, PythonIndexer indexer, PythonFileConsumer architectureCallback) {
        super(context);
        this.checks = checks;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.cpdAnalyzer = new PythonCpdAnalyzer(context);
        this.parserSupplier = parserSupplier;
        this.indexer = indexer;
        this.indexer.buildOnce(context);
        this.architectureCallback = architectureCallback;
    }

    @Override
    protected String name() {
        return "rules execution";
    }

    @Override
    protected void scanFile(PythonInputFile inputFile) throws IOException {
        PythonVisitorContext visitorContext;
        PythonFile pythonFile = SonarQubePythonFile.create((PythonInputFile)inputFile);
        InputFile.Type fileType = inputFile.wrappedFile().type();
        try {
            AstNode astNode = this.parserSupplier.get().parse(inputFile.contents());
            PythonTreeMaker treeMaker = PythonScanner.getTreeMaker(inputFile);
            FileInput parse = treeMaker.fileInput(astNode);
            visitorContext = new PythonVisitorContext(parse, pythonFile, PythonScanner.getWorkingDirectory(this.context), this.indexer.packageName(inputFile), this.indexer.projectLevelSymbolTable(), this.indexer.cacheContext(), this.context.runtime().getProduct());
            if (fileType == InputFile.Type.MAIN) {
                this.saveMeasures(inputFile, visitorContext);
            }
        }
        catch (RecognitionException e) {
            visitorContext = new PythonVisitorContext(pythonFile, e, this.context.runtime().getProduct());
            int line = inputFile.kind() == PythonInputFile.Kind.IPYTHON ? ((IPythonLocation)((GeneratedIPythonFile)inputFile).locationMap().get(e.getLine())).line() : e.getLine();
            String newMessage = e.getMessage().replace("line " + e.getLine(), "line " + line);
            LOG.error("Unable to parse file: " + String.valueOf(inputFile));
            LOG.error(newMessage);
            ++this.recognitionErrorCount;
            this.context.newAnalysisError().onFile(inputFile.wrappedFile()).at(inputFile.wrappedFile().newPointer(line, 0)).message(newMessage).save();
        }
        ArrayList<PythonSubscriptionCheck> checksBasedOnTree = new ArrayList<PythonSubscriptionCheck>();
        for (PythonCheck check : this.checks.all()) {
            if (!this.isCheckApplicable(check, fileType) || this.checksExecutedWithoutParsingByFiles.getOrDefault(inputFile, Collections.emptySet()).contains(check)) continue;
            if (check instanceof PythonSubscriptionCheck) {
                PythonSubscriptionCheck pythonSubscriptionCheck = (PythonSubscriptionCheck)check;
                checksBasedOnTree.add(pythonSubscriptionCheck);
                continue;
            }
            check.scanFile(visitorContext);
        }
        SubscriptionVisitor.analyze(checksBasedOnTree, (PythonVisitorContext)visitorContext);
        this.architectureCallback.scanFile(visitorContext);
        this.saveIssues(inputFile, visitorContext.getIssues());
        if (visitorContext.rootTree() != null && !PythonScanner.isInSonarLint(this.context)) {
            new SymbolVisitor(this.context.newSymbolTable().onFile(inputFile.wrappedFile())).visitFileInput(visitorContext.rootTree());
            new PythonHighlighter(this.context, inputFile).scanFile(visitorContext);
        }
        this.searchForDataBricks(visitorContext);
    }

    private void searchForDataBricks(PythonVisitorContext visitorContext) {
        this.foundDatabricks |= visitorContext.pythonFile().content().lines().anyMatch(line -> DATABRICKS_MAGIC_COMMAND_PATTERN.matcher((CharSequence)line).matches());
    }

    private static PythonTreeMaker getTreeMaker(PythonInputFile inputFile) {
        return "py".equals(inputFile.wrappedFile().language()) ? new PythonTreeMaker() : new IPythonTreeMaker(PythonScanner.getOffsetLocations(inputFile));
    }

    private static Map<Integer, IPythonLocation> getOffsetLocations(PythonInputFile inputFile) {
        if (inputFile.kind() == PythonInputFile.Kind.IPYTHON) {
            return ((GeneratedIPythonFile)inputFile).locationMap();
        }
        return Map.of();
    }

    @Override
    public boolean scanFileWithoutParsing(PythonInputFile inputFile) {
        InputFile.Type fileType = inputFile.wrappedFile().type();
        boolean result = true;
        PythonFile pythonFile = SonarQubePythonFile.create((InputFile)inputFile.wrappedFile());
        PythonInputFileContext inputFileContext = new PythonInputFileContext(pythonFile, this.context.fileSystem().workDir(), this.indexer.cacheContext(), this.context.runtime().getProduct(), this.indexer.projectLevelSymbolTable());
        for (PythonCheck check : this.checks.all()) {
            if (!this.isCheckApplicable(check, fileType)) continue;
            if (this.checkRequiresParsingOfImpactedFile(inputFile, check)) {
                result = false;
                continue;
            }
            if (check.scanWithoutParsing(inputFileContext)) {
                Set executedChecks = this.checksExecutedWithoutParsingByFiles.getOrDefault(inputFile, new HashSet());
                executedChecks.add(check);
                this.checksExecutedWithoutParsingByFiles.putIfAbsent(inputFile, executedChecks);
                continue;
            }
            result = false;
        }
        if (!(result &= this.architectureCallback.scanWithoutParsing(inputFileContext))) {
            return false;
        }
        return this.restoreAndPushMeasuresIfApplicable(inputFile);
    }

    private boolean checkRequiresParsingOfImpactedFile(PythonInputFile inputFile, PythonCheck check) {
        return !this.indexer.canBeFullyScannedWithoutParsing(inputFile) && !check.getClass().getPackageName().startsWith("org.sonar.python.checks");
    }

    @Override
    public void endOfAnalysis() {
        this.indexer.postAnalysis(this.context);
        this.checks.all().stream().filter(EndOfAnalysis.class::isInstance).map(EndOfAnalysis.class::cast).forEach(c -> c.endOfAnalysis(this.indexer.cacheContext()));
    }

    boolean isCheckApplicable(PythonCheck pythonCheck, InputFile.Type fileType) {
        PythonCheck.CheckScope checkScope = pythonCheck.scope();
        if (checkScope == PythonCheck.CheckScope.ALL) {
            return true;
        }
        return fileType == InputFile.Type.MAIN;
    }

    static File getWorkingDirectory(SensorContext context) {
        return PythonScanner.isInSonarLint(context) ? null : context.fileSystem().workDir();
    }

    private static boolean isInSonarLint(SensorContext context) {
        return context.runtime().getProduct().equals((Object)SonarProduct.SONARLINT);
    }

    @Override
    protected void processException(Exception e, PythonInputFile file) {
        LOG.warn("Unable to analyze file: " + String.valueOf(file), (Throwable)e);
    }

    @Override
    public boolean canBeScannedWithoutParsing(PythonInputFile inputFile) {
        return this.indexer.canBePartiallyScannedWithoutParsing(inputFile);
    }

    @Override
    protected void reportStatistics(int numSkippedFiles, int numTotalFiles) {
        LOG.info("The Python analyzer was able to leverage cached data from previous analyses for {} out of {} files. These files were not parsed.", (Object)numSkippedFiles, (Object)numTotalFiles);
    }

    private void saveIssues(PythonInputFile inputFile, List<PythonCheck.PreciseIssue> issues) {
        for (PythonCheck.PreciseIssue preciseIssue : issues) {
            RuleKey ruleKey = this.checks.ruleKey(preciseIssue.check());
            NewIssue newIssue = this.context.newIssue().forRule(ruleKey);
            Integer cost = preciseIssue.cost();
            if (cost != null) {
                newIssue.gap(Double.valueOf(cost.doubleValue()));
            }
            NewIssueLocation primaryLocation = PythonScanner.newLocation(inputFile, newIssue, preciseIssue.primaryLocation());
            newIssue.at(primaryLocation);
            ArrayDeque<NewIssueLocation> secondaryLocationsFlow = new ArrayDeque<NewIssueLocation>();
            for (IssueLocation secondaryLocation : preciseIssue.secondaryLocations()) {
                String fileId = secondaryLocation.fileId();
                if (fileId != null) {
                    InputFile issueLocationFile = this.component(fileId, this.context);
                    if (issueLocationFile == null) continue;
                    secondaryLocationsFlow.addFirst(PythonScanner.newLocation((PythonInputFile)new PythonInputFileImpl(issueLocationFile), newIssue, secondaryLocation));
                    continue;
                }
                newIssue.addLocation(PythonScanner.newLocation(inputFile, newIssue, secondaryLocation));
            }
            if (!secondaryLocationsFlow.isEmpty()) {
                secondaryLocationsFlow.addFirst(primaryLocation);
                newIssue.addFlow(secondaryLocationsFlow);
            }
            this.handleQuickFixes(inputFile.wrappedFile(), ruleKey, newIssue, preciseIssue);
            newIssue.save();
        }
    }

    @CheckForNull
    private InputFile component(String fileId, SensorContext sensorContext) {
        InputFile inputFile = Optional.ofNullable(sensorContext.fileSystem().inputFile(sensorContext.fileSystem().predicates().is(new File(fileId)))).orElseGet(() -> this.indexer.getFileWithId(fileId));
        if (inputFile == null) {
            LOG.debug("Failed to find InputFile for {}", (Object)fileId);
        }
        return inputFile;
    }

    private static NewIssueLocation newLocation(PythonInputFile inputFile, NewIssue issue, IssueLocation location) {
        String message;
        NewIssueLocation newLocation = issue.newLocation().on((InputComponent)inputFile.wrappedFile());
        if (location.startLine() != 0) {
            TextRange range = location.startLineOffset() == -1 ? inputFile.wrappedFile().selectLine(location.startLine()) : inputFile.wrappedFile().newRange(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset());
            newLocation.at(range);
        }
        if ((message = location.message()) != null) {
            newLocation.message(message);
        }
        return newLocation;
    }

    private void saveMeasures(PythonInputFile inputFile, PythonVisitorContext visitorContext) {
        FileMetrics fileMetrics = new FileMetrics(visitorContext, PythonScanner.isNotebook(inputFile));
        FileLinesVisitor fileLinesVisitor = fileMetrics.fileLinesVisitor();
        this.noSonarFilter.noSonarInFile(inputFile.wrappedFile(), fileLinesVisitor.getLinesWithNoSonar());
        if (!PythonScanner.isInSonarLint(this.context)) {
            int line;
            Iterator iterator;
            if (inputFile.kind() == PythonInputFile.Kind.PYTHON) {
                this.cpdAnalyzer.pushCpdTokens(inputFile.wrappedFile(), visitorContext);
            }
            Set linesOfCode = fileLinesVisitor.getLinesOfCode();
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.NCLOC, linesOfCode.size());
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.STATEMENTS, fileMetrics.numberOfStatements());
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.FUNCTIONS, fileMetrics.numberOfFunctions());
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.CLASSES, fileMetrics.numberOfClasses());
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COMPLEXITY, fileMetrics.complexity());
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COGNITIVE_COMPLEXITY, fileMetrics.cognitiveComplexity());
            this.saveMetricOnFile(inputFile, (Metric<Integer>)CoreMetrics.COMMENT_LINES, fileLinesVisitor.getCommentLineCount());
            FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile.wrappedFile());
            if (inputFile.kind() == PythonInputFile.Kind.PYTHON) {
                iterator = linesOfCode.iterator();
                while (iterator.hasNext()) {
                    line = (Integer)iterator.next();
                    fileLinesContext.setIntValue("ncloc_data", line, 1);
                }
            }
            iterator = fileLinesVisitor.getExecutableLines().iterator();
            while (iterator.hasNext()) {
                line = (Integer)iterator.next();
                fileLinesContext.setIntValue("executable_lines_data", line, 1);
            }
            fileLinesContext.save();
        }
    }

    static boolean isNotebook(PythonInputFile inputFile) {
        return inputFile.kind() == PythonInputFile.Kind.IPYTHON;
    }

    private boolean restoreAndPushMeasuresIfApplicable(PythonInputFile inputFile) {
        if (inputFile.wrappedFile().type() == InputFile.Type.TEST) {
            return true;
        }
        return this.cpdAnalyzer.pushCachedCpdTokens(inputFile.wrappedFile(), this.indexer.cacheContext());
    }

    private void saveMetricOnFile(PythonInputFile inputFile, Metric<Integer> metric, Integer value) {
        this.context.newMeasure().withValue((Serializable)value).forMetric(metric).on((InputComponent)inputFile.wrappedFile()).save();
    }

    private void handleQuickFixes(InputFile inputFile, RuleKey ruleKey, NewIssue newIssue, PythonCheck.PreciseIssue preciseIssue) {
        if (PythonScanner.isInSonarLint(this.context)) {
            List quickFixes = preciseIssue.quickFixes();
            PythonScanner.addQuickFixes(inputFile, ruleKey, quickFixes, newIssue);
        }
    }

    private static void addQuickFixes(InputFile inputFile, RuleKey ruleKey, Iterable<PythonQuickFix> quickFixes, NewIssue sonarLintIssue) {
        try {
            for (PythonQuickFix quickFix : quickFixes) {
                NewQuickFix newQuickFix = sonarLintIssue.newQuickFix().message(quickFix.getDescription());
                NewInputFileEdit edit = newQuickFix.newInputFileEdit().on(inputFile);
                quickFix.getTextEdits().stream().map(pythonTextEdit -> edit.newTextEdit().at(PythonScanner.rangeFromTextSpan(inputFile, pythonTextEdit)).withNewText(pythonTextEdit.replacementText())).forEach(arg_0 -> ((NewInputFileEdit)edit).addTextEdit(arg_0));
                newQuickFix.addInputFileEdit(edit);
                sonarLintIssue.addQuickFix(newQuickFix);
            }
        }
        catch (RuntimeException e) {
            LOG.warn(String.format("Could not report quick fixes for rule: %s. %s: %s", ruleKey, e.getClass().getName(), e.getMessage()));
        }
    }

    private static TextRange rangeFromTextSpan(InputFile file, PythonTextEdit pythonTextEdit) {
        return file.newRange(pythonTextEdit.startLine(), pythonTextEdit.startLineOffset(), pythonTextEdit.endLine(), pythonTextEdit.endLineOffset());
    }

    public int getRecognitionErrorCount() {
        return this.recognitionErrorCount;
    }

    public boolean getFoundDatabricks() {
        return this.foundDatabricks;
    }
}

