/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.sonar.sslr.api.RecognitionException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.python.MultiFileProgressReport;
import org.sonar.plugins.python.PythonInputFile;

public abstract class Scanner {
    private static final Logger LOG = LoggerFactory.getLogger(Scanner.class);
    private static final String FAIL_FAST_PROPERTY_NAME = "sonar.internal.analysis.failFast";
    protected final SensorContext context;

    protected Scanner(SensorContext context) {
        this.context = context;
    }

    public void execute(List<PythonInputFile> files, SensorContext context) {
        MultiFileProgressReport progressReport = new MultiFileProgressReport(this.name());
        String name = this.name();
        LOG.info("Starting {}", (Object)name);
        List<String> filenames = this.getFilesStream(files).map(PythonInputFile::wrappedFile).map(InputFile::toString).toList();
        AtomicInteger numScannedWithoutParsing = new AtomicInteger();
        progressReport.start(filenames.size());
        this.processFiles(files, context, progressReport, numScannedWithoutParsing);
        this.endOfAnalysis();
        progressReport.stop();
        this.reportStatistics(numScannedWithoutParsing.get(), files.size());
    }

    protected void processFiles(List<PythonInputFile> files, SensorContext context, MultiFileProgressReport progressReport, AtomicInteger numScannedWithoutParsing) {
        this.getFilesStream(files).forEach(file -> this.processFile(context, (PythonInputFile)file, progressReport, numScannedWithoutParsing));
    }

    protected Stream<PythonInputFile> getFilesStream(List<PythonInputFile> files) {
        return files.stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(SensorContext context, PythonInputFile file, MultiFileProgressReport progressReport, AtomicInteger numScannedWithoutParsing) {
        if (context.isCancelled()) {
            progressReport.cancel();
            return;
        }
        String filename = file.wrappedFile().filename();
        try {
            progressReport.startAnalysisFor(filename);
            boolean successfullyScannedWithoutParsing = false;
            if (this.canBeScannedWithoutParsing(file)) {
                successfullyScannedWithoutParsing = this.scanFileWithoutParsing(file);
            }
            if (!successfullyScannedWithoutParsing) {
                this.scanFile(file);
            } else {
                numScannedWithoutParsing.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.processException(e, file);
            if (context.config().getBoolean(FAIL_FAST_PROPERTY_NAME).orElse(false).booleanValue() && !Scanner.isParseErrorOnTestFile(file, e)) {
                throw new IllegalStateException("Exception when analyzing " + String.valueOf(file), e);
            }
        }
        finally {
            progressReport.finishAnalysisFor(filename);
        }
    }

    protected abstract String name();

    protected abstract void scanFile(PythonInputFile var1) throws IOException;

    protected boolean scanFileWithoutParsing(PythonInputFile file) throws IOException {
        return false;
    }

    protected void endOfAnalysis() {
    }

    protected abstract void processException(Exception var1, PythonInputFile var2);

    protected void reportStatistics(int numSkippedFiles, int numTotalFiles) {
    }

    public boolean canBeScannedWithoutParsing(PythonInputFile inputFile) {
        return false;
    }

    private static boolean isParseErrorOnTestFile(PythonInputFile file, Exception e) {
        return e instanceof RecognitionException && file.wrappedFile().type() == InputFile.Type.TEST;
    }
}

