/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.io.File;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.fix.NewInputFileEdit;
import org.sonar.api.batch.sensor.issue.fix.NewQuickFix;
import org.sonar.api.rule.RuleKey;
import org.sonar.plugins.python.PythonChecks;
import org.sonar.plugins.python.PythonInputFile;
import org.sonar.plugins.python.PythonInputFileImpl;
import org.sonar.plugins.python.api.IssueLocation;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.quickfix.PythonQuickFix;
import org.sonar.plugins.python.api.quickfix.PythonTextEdit;
import org.sonar.plugins.python.indexer.PythonIndexer;

public class IssuesRepository {
    private static final Logger LOG = LoggerFactory.getLogger(IssuesRepository.class);
    private final SensorContext context;
    private final PythonChecks checks;
    private final PythonIndexer indexer;
    private final boolean isInSonarLint;
    private final Object monitor;

    public IssuesRepository(SensorContext context, PythonChecks checks, PythonIndexer indexer, boolean isInSonarLint, Object monitor) {
        this.context = context;
        this.checks = checks;
        this.indexer = indexer;
        this.isInSonarLint = isInSonarLint;
        this.monitor = monitor;
    }

    public void save(PythonInputFile inputFile, List<PythonCheck.PreciseIssue> issues) {
        issues.forEach(preciseIssue -> this.save(inputFile, (PythonCheck.PreciseIssue)preciseIssue));
    }

    private void save(PythonInputFile inputFile, PythonCheck.PreciseIssue preciseIssue) {
        RuleKey ruleKey = this.checks.ruleKey(preciseIssue.check());
        NewIssue newIssue = this.context.newIssue().forRule(ruleKey);
        Integer cost = preciseIssue.cost();
        if (cost != null) {
            newIssue.gap(Double.valueOf(cost.doubleValue()));
        }
        NewIssueLocation primaryLocation = IssuesRepository.newLocation(inputFile, newIssue, preciseIssue.primaryLocation());
        newIssue.at(primaryLocation);
        ArrayDeque<NewIssueLocation> secondaryLocationsFlow = new ArrayDeque<NewIssueLocation>();
        for (IssueLocation secondaryLocation : preciseIssue.secondaryLocations()) {
            String fileId = secondaryLocation.fileId();
            if (fileId != null) {
                InputFile issueLocationFile = this.component(fileId, this.context);
                if (issueLocationFile == null) continue;
                secondaryLocationsFlow.addFirst(IssuesRepository.newLocation((PythonInputFile)new PythonInputFileImpl(issueLocationFile), newIssue, secondaryLocation));
                continue;
            }
            newIssue.addLocation(IssuesRepository.newLocation(inputFile, newIssue, secondaryLocation));
        }
        if (!secondaryLocationsFlow.isEmpty()) {
            secondaryLocationsFlow.addFirst(primaryLocation);
            newIssue.addFlow(secondaryLocationsFlow);
        }
        this.handleQuickFixes(inputFile.wrappedFile(), ruleKey, newIssue, preciseIssue);
        this.save(newIssue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(NewIssue newIssue) {
        Object object = this.monitor;
        synchronized (object) {
            newIssue.save();
        }
    }

    @CheckForNull
    private InputFile component(String fileId, SensorContext sensorContext) {
        FilePredicate predicate = sensorContext.fileSystem().predicates().is(new File(fileId));
        InputFile inputFile = Optional.ofNullable(sensorContext.fileSystem().inputFile(predicate)).orElseGet(() -> this.indexer.getFileWithId(fileId));
        if (inputFile == null) {
            LOG.debug("Failed to find InputFile for {}", (Object)fileId);
        }
        return inputFile;
    }

    private static NewIssueLocation newLocation(PythonInputFile inputFile, NewIssue issue, IssueLocation location) {
        String message;
        NewIssueLocation newLocation = issue.newLocation().on((InputComponent)inputFile.wrappedFile());
        if (location.startLine() != 0) {
            TextRange range = location.startLineOffset() == -1 ? inputFile.wrappedFile().selectLine(location.startLine()) : inputFile.wrappedFile().newRange(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset());
            newLocation.at(range);
        }
        if ((message = location.message()) != null) {
            newLocation.message(message);
        }
        return newLocation;
    }

    private void handleQuickFixes(InputFile inputFile, RuleKey ruleKey, NewIssue newIssue, PythonCheck.PreciseIssue preciseIssue) {
        if (this.isInSonarLint) {
            List quickFixes = preciseIssue.quickFixes();
            IssuesRepository.addQuickFixes(inputFile, ruleKey, quickFixes, newIssue);
        }
    }

    private static void addQuickFixes(InputFile inputFile, RuleKey ruleKey, Iterable<PythonQuickFix> quickFixes, NewIssue sonarLintIssue) {
        try {
            for (PythonQuickFix quickFix : quickFixes) {
                NewQuickFix newQuickFix = sonarLintIssue.newQuickFix().message(quickFix.getDescription());
                NewInputFileEdit edit = newQuickFix.newInputFileEdit().on(inputFile);
                quickFix.getTextEdits().stream().map(pythonTextEdit -> edit.newTextEdit().at(IssuesRepository.rangeFromTextSpan(inputFile, pythonTextEdit)).withNewText(pythonTextEdit.replacementText())).forEach(arg_0 -> ((NewInputFileEdit)edit).addTextEdit(arg_0));
                newQuickFix.addInputFileEdit(edit);
                sonarLintIssue.addQuickFix(newQuickFix);
            }
        }
        catch (RuntimeException e) {
            LOG.warn("Could not report quick fixes for rule: {}. {}: {}", new Object[]{ruleKey, e.getClass().getName(), e.getMessage()});
        }
    }

    private static TextRange rangeFromTextSpan(InputFile file, PythonTextEdit pythonTextEdit) {
        return file.newRange(pythonTextEdit.startLine(), pythonTextEdit.startLineOffset(), pythonTextEdit.endLine(), pythonTextEdit.endLineOffset());
    }
}

