/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import java.time.Instant;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiFileProgressReport
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(MultiFileProgressReport.class);
    private static final int MAX_NUMBER_OF_FILES_TO_DISPLAY = 3;
    private static final int DEFAULT_PROGRESS_UPDATE_PERIOD_MILLIS = 10000;
    private final Collection<String> currentFileNames = new ConcurrentLinkedDeque<String>();
    private long size;
    private long numberOfFinishedFiles;
    private final Thread thread;
    private final long progressUpdatePeriod;
    private boolean success;
    private Instant startInstant;
    private final AtomicBoolean interrupted = new AtomicBoolean();

    public MultiFileProgressReport(String stepName) {
        this(10000L, stepName);
    }

    public MultiFileProgressReport(long progressUpdatePeriod) {
        this(progressUpdatePeriod, "default");
    }

    public MultiFileProgressReport(long progressUpdatePeriod, String stepName) {
        this.progressUpdatePeriod = progressUpdatePeriod;
        this.interrupted.set(false);
        this.thread = new Thread(this);
        this.thread.setName(stepName);
        this.thread.setDaemon(true);
        this.thread.setUncaughtExceptionHandler((thread, throwable) -> LOG.debug("Uncaught exception in the progress report thread: {}", (Object)throwable.getClass().getCanonicalName()));
    }

    @Override
    public void run() {
        this.startInstant = Instant.now();
        MultiFileProgressReport.log(this.size + " source " + MultiFileProgressReport.pluralizeFile(this.size) + " to be analyzed", false);
        while (!this.interrupted.get() && !Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(this.progressUpdatePeriod);
                this.logCurrentProgress();
            }
            catch (InterruptedException e) {
                this.interrupted.set(true);
                this.thread.interrupt();
                break;
            }
        }
        if (this.success) {
            MultiFileProgressReport.log(this.size + "/" + this.size + " source " + MultiFileProgressReport.pluralizeFile(this.size) + " " + MultiFileProgressReport.pluralizeHas(this.size) + " been analyzed", false);
        }
    }

    private static String pluralizeFile(long count) {
        if (count == 1L) {
            return "file";
        }
        return "files";
    }

    private static String pluralizeHas(long count) {
        if (count == 1L) {
            return "has";
        }
        return "have";
    }

    public synchronized void start(int size) {
        this.size = size;
        this.thread.start();
    }

    public void startAnalysisFor(String fileName) {
        this.currentFileNames.add(fileName);
    }

    public synchronized void finishAnalysisFor(String fileName) {
        if (!this.currentFileNames.remove(fileName)) {
            LOG.debug("Couldn't finish progress report of file \"{}\", as it was not in the list of files being analyzed", (Object)fileName);
            return;
        }
        if (this.numberOfFinishedFiles < this.size) {
            ++this.numberOfFinishedFiles;
        } else {
            LOG.debug("Reported finished analysis on more files than expected");
        }
    }

    public synchronized void stop() {
        this.interrupted.set(true);
        this.success = true;
        this.thread.interrupt();
        this.join();
        this.logFinishTime();
    }

    public synchronized void cancel() {
        this.interrupted.set(true);
        this.thread.interrupt();
        this.join();
        this.logFinishTime();
    }

    private void join() {
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCurrentProgress() {
        LinkedHashSet<String> currentFileNamesCopy;
        StringBuilder sb = new StringBuilder();
        MultiFileProgressReport multiFileProgressReport = this;
        synchronized (multiFileProgressReport) {
            currentFileNamesCopy = new LinkedHashSet<String>(this.currentFileNames);
        }
        int numberOfFiles = currentFileNamesCopy.size();
        sb.append(this.numberOfFinishedFiles).append("/").append(this.size).append(" files analyzed, current ").append(MultiFileProgressReport.pluralizeFile(numberOfFiles)).append(": ");
        boolean debugEnabled = LOG.isDebugEnabled();
        if (numberOfFiles == 0) {
            sb.append("none");
        } else {
            int numberOfFilesToDisplay = debugEnabled ? numberOfFiles : Math.min(numberOfFiles, 3);
            String fileNamesToDisplay = currentFileNamesCopy.stream().limit(numberOfFilesToDisplay).collect(Collectors.joining(", "));
            sb.append(fileNamesToDisplay);
            if (numberOfFiles > numberOfFilesToDisplay) {
                sb.append(", ...");
            }
        }
        MultiFileProgressReport.log(sb.toString(), debugEnabled);
    }

    private void logFinishTime() {
        MultiFileProgressReport.log("Finished step " + this.thread.getName() + " in " + (Instant.now().toEpochMilli() - this.startInstant.toEpochMilli()) + "ms", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(String message, boolean debug) {
        Logger logger = LOG;
        synchronized (logger) {
            if (debug) {
                LOG.debug(message);
            } else {
                LOG.info(message);
            }
            LOG.notifyAll();
        }
    }
}

