/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugin;
import org.sonar.api.PropertyType;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarRuntime;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.plugins.python.DependencyTelemetrySensor;
import org.sonar.plugins.python.IPynb;
import org.sonar.plugins.python.IPynbProfile;
import org.sonar.plugins.python.IPynbRuleRepository;
import org.sonar.plugins.python.IPynbSensor;
import org.sonar.plugins.python.Python;
import org.sonar.plugins.python.PythonProfile;
import org.sonar.plugins.python.PythonRuleRepository;
import org.sonar.plugins.python.PythonSensor;
import org.sonar.plugins.python.api.PythonCustomRuleRepositoryWrapper;
import org.sonar.plugins.python.api.SonarLintCache;
import org.sonar.plugins.python.api.SonarLintCacheWrapper;
import org.sonar.plugins.python.architecture.ArchitectureCallbackWrapper;
import org.sonar.plugins.python.bandit.BanditRulesDefinition;
import org.sonar.plugins.python.bandit.BanditSensor;
import org.sonar.plugins.python.coverage.PythonCoverageSensor;
import org.sonar.plugins.python.editions.OpenSourceRepositoryInfoProvider;
import org.sonar.plugins.python.editions.RepositoryInfoProviderWrapper;
import org.sonar.plugins.python.flake8.Flake8RulesDefinition;
import org.sonar.plugins.python.flake8.Flake8Sensor;
import org.sonar.plugins.python.indexer.PythonIndexerWrapper;
import org.sonar.plugins.python.indexer.SonarLintPythonIndexer;
import org.sonar.plugins.python.mypy.MypyRulesDefinition;
import org.sonar.plugins.python.mypy.MypySensor;
import org.sonar.plugins.python.nosonar.NoSonarIssueFilter;
import org.sonar.plugins.python.nosonar.NoSonarLineInfoCollector;
import org.sonar.plugins.python.pylint.PylintRulesDefinition;
import org.sonar.plugins.python.pylint.PylintSensor;
import org.sonar.plugins.python.ruff.RuffRulesDefinition;
import org.sonar.plugins.python.ruff.RuffSensor;
import org.sonar.plugins.python.warnings.AnalysisWarningsWrapper;
import org.sonar.plugins.python.xunit.PythonXUnitSensor;
import org.sonar.python.project.config.ProjectConfigurationBuilder;

public class PythonExtensions {
    private static final Logger LOG = LoggerFactory.getLogger(PythonExtensions.class);
    public static final String PYTHON_FILE_SUFFIXES_KEY = "sonar.python.file.suffixes";
    public static final String IPYNB_FILE_SUFFIXES_KEY = "sonar.ipynb.file.suffixes";
    static final String PYTHON_CATEGORY = "Python";
    static final String GENERAL = "General";
    private static final String TEST_AND_COVERAGE = "Tests and Coverage";
    private static final String EXTERNAL_ANALYZERS_CATEGORY = "External Analyzers";
    private static final String DEPRECATED_PREFIX = "DEPRECATED : Use sonar.python.coverage.reportPaths instead. ";

    private PythonExtensions() {
    }

    public static void addCommonExtensions(Plugin.Context context) {
        context.addExtensions(ProjectConfigurationBuilder.class, NoSonarLineInfoCollector.class, new Object[]{NoSonarIssueFilter.class, PythonExtensions.buildPythonSuffix(), PythonExtensions.buildIpynbPythonSuffix(), PythonExtensions.buildPythonVersion(), Python.class, PythonProfile.class, PythonSensor.class, PythonRuleRepository.class, AnalysisWarningsWrapper.class, ArchitectureCallbackWrapper.class, PythonCustomRuleRepositoryWrapper.class, PythonIndexerWrapper.class, RepositoryInfoProviderWrapper.class, SonarLintCacheWrapper.class, IPynb.class, IPynbProfile.class, IPynbSensor.class, IPynbRuleRepository.class, OpenSourceRepositoryInfoProvider.class});
        SonarRuntime sonarRuntime = context.getRuntime();
        if (sonarRuntime.getProduct() != SonarProduct.SONARLINT) {
            PythonExtensions.addCoberturaExtensions(context);
            PythonExtensions.addXUnitExtensions(context);
            PythonExtensions.addPylintExtensions(context);
            PythonExtensions.addBanditExtensions(context);
            PythonExtensions.addFlake8Extensions(context);
            PythonExtensions.addMypyExtensions(context);
            PythonExtensions.addRuffExtensions(context);
            context.addExtension(DependencyTelemetrySensor.class);
        }
        if (sonarRuntime.getProduct() == SonarProduct.SONARLINT) {
            SonarLintPluginAPIManager sonarLintPluginAPIManager = new SonarLintPluginAPIManager();
            sonarLintPluginAPIManager.addSonarlintPythonIndexer(context, new SonarLintPluginAPIVersion());
        }
    }

    private static void addCoberturaExtensions(Plugin.Context context) {
        context.addExtensions((Object)PropertyDefinition.builder((String)"sonar.python.coverage.reportPaths").index(20).name("Path to coverage report(s)").description("List of paths pointing to coverage reports. Ant patterns are accepted for relative path. The reports have to conform to the Cobertura XML format.").category(PYTHON_CATEGORY).subCategory(TEST_AND_COVERAGE).onQualifiers("TRK", new String[0]).defaultValue("coverage-reports/*coverage-*.xml").multiValues(true).build(), (Object)PropertyDefinition.builder((String)"sonar.python.coverage.reportPath").index(21).name("Path to coverage report").description("DEPRECATED : Use sonar.python.coverage.reportPaths instead. Path to a coverage report. Ant patterns are accepted for relative path. The report has to conform to the Cobertura XML format.").category(PYTHON_CATEGORY).subCategory(TEST_AND_COVERAGE).onQualifiers("TRK", new String[0]).defaultValue("").build(), new Object[]{PythonCoverageSensor.class});
    }

    private static void addXUnitExtensions(Plugin.Context context) {
        context.addExtensions((Object)PropertyDefinition.builder((String)"sonar.python.xunit.skipDetails").index(23).name("Skip the details when importing the Xunit reports").description("When enabled the test execution statistics is provided only on project level. Use this mode when paths in report are not found. Disabled by default.").category(PYTHON_CATEGORY).subCategory(TEST_AND_COVERAGE).onQualifiers("TRK", new String[0]).defaultValue("false").type(PropertyType.BOOLEAN).build(), (Object)PropertyDefinition.builder((String)"sonar.python.xunit.reportPath").index(24).name("Path to xunit report(s)").description("Path to the report of test execution, relative to project's root. Ant patterns are accepted. The reports have to conform to the junitreport XML format.").category(PYTHON_CATEGORY).subCategory(TEST_AND_COVERAGE).onQualifiers("TRK", new String[0]).defaultValue("xunit-reports/xunit-result-*.xml").build(), new Object[]{PythonXUnitSensor.class});
    }

    private static void addBanditExtensions(Plugin.Context context) {
        context.addExtensions(BanditSensor.class, (Object)PropertyDefinition.builder((String)"sonar.python.bandit.reportPaths").name("Bandit Report Files").description("Paths (absolute or relative) to json files with Bandit issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(PYTHON_CATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build(), new Object[]{BanditRulesDefinition.class});
    }

    private static void addPylintExtensions(Plugin.Context context) {
        context.addExtensions(PylintSensor.class, (Object)PropertyDefinition.builder((String)"sonar.python.pylint.reportPaths").name("Pylint Report Files").description("Paths (absolute or relative) to report files with Pylint issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(PYTHON_CATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build(), new Object[]{PylintRulesDefinition.class});
    }

    private static void addFlake8Extensions(Plugin.Context context) {
        context.addExtensions(Flake8Sensor.class, (Object)PropertyDefinition.builder((String)"sonar.python.flake8.reportPaths").name("Flake8 Report Files").description("Paths (absolute or relative) to report files with Flake8 issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(PYTHON_CATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build(), new Object[]{Flake8RulesDefinition.class});
    }

    private static void addMypyExtensions(Plugin.Context context) {
        context.addExtensions(MypySensor.class, (Object)PropertyDefinition.builder((String)"sonar.python.mypy.reportPaths").name("Mypy Report Files").description("Paths (absolute or relative) to report files with Mypy issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(PYTHON_CATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build(), new Object[]{MypyRulesDefinition.class});
    }

    private static void addRuffExtensions(Plugin.Context context) {
        context.addExtensions(RuffSensor.class, (Object)PropertyDefinition.builder((String)"sonar.python.ruff.reportPaths").name("Ruff Report Files").description("Paths (absolute or relative) to report files with Ruff issues.").category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(PYTHON_CATEGORY).onQualifiers("TRK", new String[0]).multiValues(true).build(), new Object[]{RuffRulesDefinition.class});
    }

    private static PropertyDefinition buildPythonVersion() {
        return PropertyDefinition.builder((String)"sonar.python.version").index(12).name("Python versions").description("Comma-separated list of Python versions this project is compatible with.").multiValues(true).category(PYTHON_CATEGORY).subCategory(GENERAL).onQualifiers("TRK", new String[0]).build();
    }

    private static PropertyDefinition buildIpynbPythonSuffix() {
        return PropertyDefinition.builder((String)IPYNB_FILE_SUFFIXES_KEY).index(11).name("IPython File Suffixes").description("List of suffixes of IPython Notebooks files to analyze.").multiValues(true).category(PYTHON_CATEGORY).subCategory(GENERAL).onQualifiers("TRK", new String[0]).defaultValue("ipynb").build();
    }

    private static PropertyDefinition buildPythonSuffix() {
        return PropertyDefinition.builder((String)PYTHON_FILE_SUFFIXES_KEY).index(10).name("File Suffixes").description("List of suffixes of Python files to analyze.").multiValues(true).category(PYTHON_CATEGORY).subCategory(GENERAL).onQualifiers("TRK", new String[0]).defaultValue("py").build();
    }

    static class SonarLintPluginAPIManager {
        SonarLintPluginAPIManager() {
        }

        public void addSonarlintPythonIndexer(Plugin.Context context, SonarLintPluginAPIVersion sonarLintPluginAPIVersion) {
            if (sonarLintPluginAPIVersion.isDependencyAvailable()) {
                context.addExtension(SonarLintCache.class);
                context.addExtension(SonarLintPythonIndexer.class);
            } else {
                LOG.debug("Error while trying to inject SonarLintPythonIndexer");
            }
        }
    }

    static class SonarLintPluginAPIVersion {
        SonarLintPluginAPIVersion() {
        }

        boolean isDependencyAvailable() {
            try {
                Class.forName("org.sonarsource.sonarlint.plugin.api.module.file.ModuleFileListener");
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return true;
        }
    }
}

