/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.indexer;

import com.sonar.sslr.api.AstNode;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.python.PythonInputFile;
import org.sonar.plugins.python.Scanner;
import org.sonar.plugins.python.SonarQubePythonFile;
import org.sonar.plugins.python.api.PythonFile;
import org.sonar.plugins.python.api.SonarLintCache;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.api.project.configuration.ProjectConfiguration;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.project.config.ProjectConfigurationBuilder;
import org.sonar.python.project.config.SignatureBasedAwsLambdaHandlersCollector;
import org.sonar.python.semantic.ProjectLevelSymbolTable;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.semantic.v2.ProjectLevelTypeTable;
import org.sonar.python.semantic.v2.TypeTable;
import org.sonar.python.tree.PythonTreeMaker;

public abstract class PythonIndexer {
    private static final Logger LOG = LoggerFactory.getLogger(PythonIndexer.class);
    protected String projectBaseDirAbsolutePath;
    private final Map<URI, String> packageNames = new ConcurrentHashMap<URI, String>();
    private final Supplier<PythonParser> parserSupplier = PythonParser::create;
    private final ProjectLevelSymbolTable projectLevelSymbolTable = ProjectLevelSymbolTable.empty();
    private ProjectLevelTypeTable projectLevelTypeTable = new ProjectLevelTypeTable(this.projectLevelSymbolTable);
    private final SignatureBasedAwsLambdaHandlersCollector signatureBasedAwsLambdaHandlersCollector = new SignatureBasedAwsLambdaHandlersCollector();
    private final ProjectConfigurationBuilder projectConfigurationBuilder;

    protected PythonIndexer(ProjectConfigurationBuilder projectConfigurationBuilder) {
        this.projectConfigurationBuilder = projectConfigurationBuilder;
    }

    public ProjectLevelSymbolTable projectLevelSymbolTable() {
        return this.projectLevelSymbolTable;
    }

    public ProjectConfiguration projectConfig() {
        return this.projectConfigurationBuilder.build();
    }

    public TypeTable projectLevelTypeTable() {
        return this.projectLevelTypeTable;
    }

    protected void recreateProjectLevelTypeTable() {
        this.projectLevelTypeTable = new ProjectLevelTypeTable(this.projectLevelSymbolTable);
    }

    public String packageName(PythonInputFile inputFile) {
        if (!this.packageNames.containsKey(inputFile.wrappedFile().uri())) {
            String name = SymbolUtils.pythonPackageName((File)inputFile.wrappedFile().file(), (String)this.projectBaseDirAbsolutePath);
            this.packageNames.put(inputFile.wrappedFile().uri(), name);
            this.projectLevelSymbolTable.addProjectPackage(name);
        }
        return this.packageNames.get(inputFile.wrappedFile().uri());
    }

    public void collectPackageNames(List<PythonInputFile> inputFiles) {
        for (PythonInputFile inputFile : inputFiles) {
            String packageName = SymbolUtils.pythonPackageName((File)inputFile.wrappedFile().file(), (String)this.projectBaseDirAbsolutePath);
            this.projectLevelSymbolTable.addProjectPackage(packageName);
        }
    }

    void removeFile(PythonInputFile inputFile) {
        String packageName = this.packageNames.get(inputFile.wrappedFile().uri());
        String filename = inputFile.wrappedFile().filename();
        if (packageName == null) {
            LOG.debug("Failed to remove file \"{}\" from project-level symbol table (file not indexed)", (Object)filename);
            return;
        }
        this.packageNames.remove(inputFile.wrappedFile().uri());
        this.projectLevelSymbolTable.removeModule(packageName, filename);
        this.projectConfigurationBuilder.removePackageAwsLambdaHandlers(packageName);
    }

    void addFile(PythonInputFile inputFile) throws IOException {
        AstNode astNode = this.parserSupplier.get().parse(inputFile.wrappedFile().contents());
        FileInput astRoot = new PythonTreeMaker().fileInput(astNode);
        String packageName = SymbolUtils.pythonPackageName((File)inputFile.wrappedFile().file(), (String)this.projectBaseDirAbsolutePath);
        this.packageNames.put(inputFile.wrappedFile().uri(), packageName);
        this.projectLevelSymbolTable.addProjectPackage(packageName);
        PythonFile pythonFile = SonarQubePythonFile.create((InputFile)inputFile.wrappedFile());
        this.projectLevelSymbolTable.addModule(astRoot, packageName, pythonFile);
        this.signatureBasedAwsLambdaHandlersCollector.collect(this.projectConfigurationBuilder, (Tree)astRoot, packageName);
    }

    public abstract void buildOnce(SensorContext var1);

    public abstract void postAnalysis(SensorContext var1);

    public void setSonarLintCache(@Nullable SonarLintCache sonarLintCache) {
    }

    @CheckForNull
    public InputFile getFileWithId(String fileId) {
        return null;
    }

    public boolean canBePartiallyScannedWithoutParsing(PythonInputFile inputFile) {
        return false;
    }

    public boolean canBeFullyScannedWithoutParsing(PythonInputFile inputFile) {
        return false;
    }

    public abstract CacheContext cacheContext();

    class GlobalSymbolsScanner
    extends Scanner {
        private static final String THREADS_PROPERTY_NAME = "sonar.python.symbols.threads";

        protected GlobalSymbolsScanner(SensorContext context) {
            super(context);
        }

        @Override
        protected String name() {
            return "global symbols computation";
        }

        @Override
        protected void logStart(int numThreads) {
            if (numThreads != 1) {
                LOG.debug("Scanning global symbols in {} threads", (Object)numThreads);
            }
        }

        @Override
        protected void scanFile(PythonInputFile inputFile) throws IOException {
            if (inputFile.kind() == PythonInputFile.Kind.PYTHON) {
                PythonIndexer.this.addFile(inputFile);
            }
        }

        @Override
        protected int getNumberOfThreads(SensorContext context) {
            return context.config().getInt(THREADS_PROPERTY_NAME).orElse(Math.max(2, Math.min((int)Math.round((double)Runtime.getRuntime().availableProcessors() * 0.9), 6)));
        }

        @Override
        protected void processException(Exception e, PythonInputFile file) {
            LOG.debug("Unable to construct project-level symbol table for file: {}", (Object)file, (Object)e);
        }
    }
}

