/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.indexer;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.plugins.python.PythonInputFile;
import org.sonar.plugins.python.api.caching.CacheContext;
import org.sonar.plugins.python.caching.Caching;
import org.sonar.plugins.python.indexer.PythonIndexer;
import org.sonar.python.index.Descriptor;
import org.sonar.python.project.config.ProjectConfigurationBuilder;
import org.sonar.python.semantic.DependencyGraph;
import org.sonar.python.semantic.SymbolUtils;
import org.sonar.python.semantic.v2.typeshed.TypeShedDescriptorsProvider;
import org.sonarsource.performance.measure.PerformanceMeasure;

public class SonarQubePythonIndexer
extends PythonIndexer {
    public static final String SONAR_CAN_SKIP_UNCHANGED_FILES_KEY = "sonar.python.skipUnchanged";
    private static final Logger LOG = LoggerFactory.getLogger(SonarQubePythonIndexer.class);
    private final Caching caching;
    private final Set<PythonInputFile> fullySkippableFiles = new HashSet<PythonInputFile>();
    private final Set<PythonInputFile> partiallySkippableFiles = new HashSet<PythonInputFile>();
    private final List<PythonInputFile> inputFiles = new ArrayList<PythonInputFile>();
    private final Map<PythonInputFile, String> inputFileToFQN = new HashMap<PythonInputFile, String>();

    public SonarQubePythonIndexer(List<PythonInputFile> inputFiles, CacheContext cacheContext, SensorContext context, ProjectConfigurationBuilder projectConfigurationBuilder) {
        super(projectConfigurationBuilder);
        this.projectBaseDirAbsolutePath = context.fileSystem().baseDir().getAbsolutePath();
        this.caching = new Caching(cacheContext, SonarQubePythonIndexer.getCacheVersion(context));
        inputFiles.forEach(f -> {
            this.inputFiles.add((PythonInputFile)f);
            this.inputFileToFQN.put((PythonInputFile)f, SymbolUtils.fullyQualifiedModuleName((String)this.packageName((PythonInputFile)f), (String)f.wrappedFile().filename()));
        });
    }

    @Override
    public void buildOnce(SensorContext context) {
        LOG.debug("Input files for indexing: {}", this.inputFiles);
        this.collectPackageNames(this.inputFiles);
        if (this.shouldOptimizeAnalysis(context)) {
            this.computeGlobalSymbolsUsingCache(context);
            return;
        }
        PerformanceMeasure.Duration duration = PerformanceMeasure.start((String)"ProjectLevelSymbolTable");
        this.computeGlobalSymbols(this.inputFiles, context);
        duration.stop();
    }

    @Override
    public void postAnalysis(SensorContext context) {
        Set stubModules;
        if (this.caching.isCacheEnabled() && !(stubModules = this.projectLevelSymbolTable().typeShedDescriptorsProvider().stubModules()).isEmpty()) {
            this.caching.writeTypeshedModules(stubModules);
        }
    }

    private boolean shouldOptimizeAnalysis(SensorContext context) {
        return this.caching.isCacheEnabled() && (context.canSkipUnchangedFiles() || context.config().getBoolean(SONAR_CAN_SKIP_UNCHANGED_FILES_KEY).orElse(false) != false) && this.caching.isCacheVersionUpToDate();
    }

    private void computeGlobalSymbolsUsingCache(SensorContext context) {
        this.loadTypeshedSymbols();
        this.projectLevelSymbolTable().typeShedDescriptorsProvider();
        LOG.info("Using cached data to retrieve global symbols.");
        HashSet<String> currentProjectModulesFQNs = new HashSet<String>(this.inputFileToFQN.values());
        Set<String> deletedModulesFQNs = this.deletedModulesFQNs(currentProjectModulesFQNs);
        Set allProjectFilesFQNs = Stream.concat(currentProjectModulesFQNs.stream(), deletedModulesFQNs.stream()).collect(Collectors.toSet());
        HashMap<String, Set<String>> importsByModule = new HashMap<String, Set<String>>();
        ArrayList<PythonInputFile> impactfulFiles = new ArrayList<PythonInputFile>();
        ArrayList<String> impactfulModulesFQNs = new ArrayList<String>(deletedModulesFQNs);
        for (PythonInputFile inputFile : this.inputFiles) {
            String currFQN;
            boolean isUnimpacted = this.tryToUseCache(importsByModule, inputFile, currFQN = this.inputFileToFQN.get(inputFile));
            if (!isUnimpacted) {
                impactfulFiles.add(inputFile);
                impactfulModulesFQNs.add(currFQN);
                continue;
            }
            this.partiallySkippableFiles.add(inputFile);
        }
        Set impactedModulesFQN = DependencyGraph.from(importsByModule, allProjectFilesFQNs).impactedModules(impactfulModulesFQNs);
        this.inputFiles.stream().filter(f -> !impactedModulesFQN.contains(this.inputFileToFQN.get(f))).forEach(this.fullySkippableFiles::add);
        LOG.info("Cached information of global symbols will be used for {} out of {} main files. Global symbols will be recomputed for the remaining files.", (Object)(this.inputFiles.size() - impactfulFiles.size()), (Object)this.inputFiles.size());
        LOG.info("Fully optimized analysis can be performed for {} out of {} files.", (Object)this.fullySkippableFiles.size(), (Object)this.inputFiles.size());
        LOG.info("Partially optimized analysis can be performed for {} out of {} files.", (Object)this.partiallySkippableFiles.size(), (Object)this.inputFiles.size());
        this.computeGlobalSymbols(impactfulFiles, context);
    }

    private void loadTypeshedSymbols() {
        TypeShedDescriptorsProvider typeshedReader = this.projectLevelSymbolTable().typeShedDescriptorsProvider();
        Set<String> typeShedModules = this.caching.readTypeshedModules();
        typeShedModules.forEach(arg_0 -> ((TypeShedDescriptorsProvider)typeshedReader).descriptorsForModule(arg_0));
    }

    private boolean tryToUseCache(Map<String, Set<String>> importsByModule, PythonInputFile inputFile, String currFQN) {
        Set<Descriptor> descriptors;
        if (!this.fileIsUnchanged(inputFile)) {
            return false;
        }
        Set<String> imports = this.caching.readImportMapEntry(inputFile.wrappedFile().key());
        if (imports != null) {
            importsByModule.put(currFQN, imports);
        }
        if ((descriptors = this.caching.readProjectLevelSymbolTableEntry(inputFile.wrappedFile().key())) != null && imports != null) {
            this.saveRetrievedDescriptors(inputFile.wrappedFile().key(), descriptors, this.caching);
            return true;
        }
        return false;
    }

    private boolean fileIsUnchanged(PythonInputFile inputFile) {
        if (!inputFile.wrappedFile().status().equals((Object)InputFile.Status.SAME)) {
            return false;
        }
        byte[] fileHash = this.caching.readFileContentHash(inputFile.wrappedFile().key());
        byte[] fileInputHash = inputFile.wrappedFile().md5Hash().getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(fileHash, fileInputHash);
    }

    private void saveRetrievedDescriptors(String fileKey, Set<Descriptor> descriptors, Caching caching) {
        this.projectLevelSymbolTable().insertEntry(fileKey, descriptors);
        caching.copyFromPrevious(fileKey);
    }

    public void computeGlobalSymbols(List<PythonInputFile> files, SensorContext context) {
        PythonIndexer.GlobalSymbolsScanner globalSymbolsStep = new PythonIndexer.GlobalSymbolsScanner(context);
        globalSymbolsStep.execute(files, context);
        if (this.caching.isCacheEnabled()) {
            this.saveGlobalSymbolsInCache(files);
            this.saveMainFilesListInCache(new HashSet<String>(this.inputFileToFQN.values()));
            this.caching.writeCacheVersion();
        }
    }

    private void saveGlobalSymbolsInCache(List<PythonInputFile> files) {
        for (PythonInputFile inputFile : files) {
            String moduleFQN = this.inputFileToFQN.get(inputFile);
            Set descriptors = this.projectLevelSymbolTable().descriptorsForModule(moduleFQN);
            Set imports = (Set)this.projectLevelSymbolTable().importsByModule().get(moduleFQN);
            if (descriptors == null || imports == null) continue;
            this.writeContentHashToCache(inputFile);
            this.caching.writeProjectLevelSymbolTableEntry(inputFile.wrappedFile().key(), descriptors);
            this.caching.writeImportsMapEntry(inputFile.wrappedFile().key(), imports);
        }
    }

    private void writeContentHashToCache(PythonInputFile inputFile) {
        byte[] contentHash = inputFile.wrappedFile().md5Hash().getBytes(StandardCharsets.UTF_8);
        this.caching.writeFileContentHash(inputFile.wrappedFile().key(), contentHash);
    }

    private Set<String> deletedModulesFQNs(Set<String> projectModulesFQNs) {
        Set<String> previousAnalysisModulesFQNs = this.caching.readFilesList();
        previousAnalysisModulesFQNs.removeAll(projectModulesFQNs);
        return previousAnalysisModulesFQNs;
    }

    private void saveMainFilesListInCache(Set<String> modulesFQN) {
        this.caching.writeFilesList(new ArrayList<String>(modulesFQN));
    }

    @Override
    public boolean canBePartiallyScannedWithoutParsing(PythonInputFile inputFile) {
        return this.partiallySkippableFiles.contains(inputFile) || this.fullySkippableFiles.contains(inputFile);
    }

    @Override
    public boolean canBeFullyScannedWithoutParsing(PythonInputFile inputFile) {
        return this.fullySkippableFiles.contains(inputFile);
    }

    @Override
    public CacheContext cacheContext() {
        return this.caching.cacheContext();
    }

    private static String getCacheVersion(SensorContext context) {
        String implementationVersion = SonarQubePythonIndexer.getImplementationVersion(SonarQubePythonIndexer.class);
        CharSequence[] pythonVersions = context.config().getStringArray("sonar.python.version");
        if (pythonVersions.length == 0) {
            return implementationVersion;
        }
        return implementationVersion + ";" + String.join((CharSequence)",", pythonVersions);
    }

    private static String getImplementationVersion(Class<?> cls) {
        String implementationVersion = cls.getPackage().getImplementationVersion();
        if (implementationVersion == null) {
            LOG.warn("Implementation version of the Python plugin not found. Cached data may not be invalidated properly, which may lead to inaccurate analysis results.");
            return "unknownPluginVersion";
        }
        return implementationVersion;
    }
}

