/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.samples.python;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionAnnotationLoader;
import org.sonar.plugins.python.api.PythonCustomRuleRepository;
import org.sonar.samples.python.CustomPythonSubscriptionCheck;
import org.sonar.samples.python.CustomPythonVisitorCheck;

public class CustomPythonRuleRepository
implements RulesDefinition,
PythonCustomRuleRepository {
    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository(this.repositoryKey(), "py").setName("My custom repo");
        new RulesDefinitionAnnotationLoader().load((RulesDefinition.NewExtendedRepository)repository, this.checkClasses().toArray(new Class[0]));
        HashMap<String, String> remediationCosts = new HashMap<String, String>();
        remediationCosts.put("visitor", "5min");
        remediationCosts.put("subscription", "10min");
        repository.rules().forEach(rule -> rule.setDebtRemediationFunction(rule.debtRemediationFunctions().constantPerIssue((String)remediationCosts.get(rule.key()))));
        repository.done();
    }

    public String repositoryKey() {
        return "python-custom-rules";
    }

    public List<Class<?>> checkClasses() {
        return Arrays.asList(CustomPythonVisitorCheck.class, CustomPythonSubscriptionCheck.class);
    }
}

