/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api.cfg;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.api.cfg.CfgBlock;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.python.PythonFile;
import org.sonar.python.cfg.ControlFlowGraphBuilder;

public class ControlFlowGraph {
    private static final Logger LOG = Loggers.get(ControlFlowGraph.class);
    private final Set<CfgBlock> blocks;
    private final CfgBlock start;
    private final CfgBlock end;
    private static Set<Tree> treesWithCfgErrors = Collections.newSetFromMap(new WeakHashMap());

    public ControlFlowGraph(Set<CfgBlock> blocks, CfgBlock start, CfgBlock end) {
        this.blocks = blocks;
        this.start = start;
        this.end = end;
    }

    @CheckForNull
    private static ControlFlowGraph build(@Nullable StatementList statementList, PythonFile file) {
        if (!treesWithCfgErrors.contains(statementList)) {
            try {
                return new ControlFlowGraphBuilder(statementList).getCfg();
            }
            catch (Exception e) {
                treesWithCfgErrors.add(statementList);
                LOG.warn("Failed to build control flow graph in file [{}]: {}", (Object)file, (Object)e.getMessage());
            }
        }
        return null;
    }

    @CheckForNull
    public static ControlFlowGraph build(FunctionDef functionDef, PythonFile file) {
        return ControlFlowGraph.build(functionDef.body(), file);
    }

    @CheckForNull
    public static ControlFlowGraph build(FileInput fileInput, PythonFile file) {
        return ControlFlowGraph.build(fileInput.statements(), file);
    }

    public CfgBlock start() {
        return this.start;
    }

    public CfgBlock end() {
        return this.end;
    }

    public Set<CfgBlock> blocks() {
        return this.blocks;
    }
}

