/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.api.tree;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.AliasedName;
import org.sonar.plugins.python.api.tree.AnnotatedAssignment;
import org.sonar.plugins.python.api.tree.ArgList;
import org.sonar.plugins.python.api.tree.AssertStatement;
import org.sonar.plugins.python.api.tree.AssignmentStatement;
import org.sonar.plugins.python.api.tree.AwaitExpression;
import org.sonar.plugins.python.api.tree.BinaryExpression;
import org.sonar.plugins.python.api.tree.BreakStatement;
import org.sonar.plugins.python.api.tree.CallExpression;
import org.sonar.plugins.python.api.tree.ClassDef;
import org.sonar.plugins.python.api.tree.CompoundAssignmentStatement;
import org.sonar.plugins.python.api.tree.ComprehensionExpression;
import org.sonar.plugins.python.api.tree.ComprehensionFor;
import org.sonar.plugins.python.api.tree.ComprehensionIf;
import org.sonar.plugins.python.api.tree.ConditionalExpression;
import org.sonar.plugins.python.api.tree.ContinueStatement;
import org.sonar.plugins.python.api.tree.Decorator;
import org.sonar.plugins.python.api.tree.DelStatement;
import org.sonar.plugins.python.api.tree.DictionaryLiteral;
import org.sonar.plugins.python.api.tree.DottedName;
import org.sonar.plugins.python.api.tree.EllipsisExpression;
import org.sonar.plugins.python.api.tree.ElseClause;
import org.sonar.plugins.python.api.tree.ExceptClause;
import org.sonar.plugins.python.api.tree.ExecStatement;
import org.sonar.plugins.python.api.tree.ExpressionList;
import org.sonar.plugins.python.api.tree.ExpressionStatement;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.FinallyClause;
import org.sonar.plugins.python.api.tree.ForStatement;
import org.sonar.plugins.python.api.tree.FunctionDef;
import org.sonar.plugins.python.api.tree.GlobalStatement;
import org.sonar.plugins.python.api.tree.IfStatement;
import org.sonar.plugins.python.api.tree.ImportFrom;
import org.sonar.plugins.python.api.tree.ImportName;
import org.sonar.plugins.python.api.tree.KeyValuePair;
import org.sonar.plugins.python.api.tree.LambdaExpression;
import org.sonar.plugins.python.api.tree.ListLiteral;
import org.sonar.plugins.python.api.tree.Name;
import org.sonar.plugins.python.api.tree.NoneExpression;
import org.sonar.plugins.python.api.tree.NonlocalStatement;
import org.sonar.plugins.python.api.tree.NumericLiteral;
import org.sonar.plugins.python.api.tree.Parameter;
import org.sonar.plugins.python.api.tree.ParameterList;
import org.sonar.plugins.python.api.tree.ParenthesizedExpression;
import org.sonar.plugins.python.api.tree.PassStatement;
import org.sonar.plugins.python.api.tree.PrintStatement;
import org.sonar.plugins.python.api.tree.QualifiedExpression;
import org.sonar.plugins.python.api.tree.RaiseStatement;
import org.sonar.plugins.python.api.tree.RegularArgument;
import org.sonar.plugins.python.api.tree.ReprExpression;
import org.sonar.plugins.python.api.tree.ReturnStatement;
import org.sonar.plugins.python.api.tree.SetLiteral;
import org.sonar.plugins.python.api.tree.SliceExpression;
import org.sonar.plugins.python.api.tree.SliceItem;
import org.sonar.plugins.python.api.tree.SliceList;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.StringElement;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.SubscriptionExpression;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.plugins.python.api.tree.TryStatement;
import org.sonar.plugins.python.api.tree.Tuple;
import org.sonar.plugins.python.api.tree.TupleParameter;
import org.sonar.plugins.python.api.tree.TypeAnnotation;
import org.sonar.plugins.python.api.tree.UnaryExpression;
import org.sonar.plugins.python.api.tree.UnpackingExpression;
import org.sonar.plugins.python.api.tree.WhileStatement;
import org.sonar.plugins.python.api.tree.WithItem;
import org.sonar.plugins.python.api.tree.WithStatement;
import org.sonar.plugins.python.api.tree.YieldExpression;
import org.sonar.plugins.python.api.tree.YieldStatement;
import org.sonar.python.tree.DictCompExpressionImpl;

public class BaseTreeVisitor
implements TreeVisitor {
    protected void scan(@Nullable Tree tree) {
        if (tree != null) {
            tree.accept(this);
        }
    }

    protected void scan(@Nullable List<? extends Tree> trees) {
        if (trees != null) {
            for (Tree tree : trees) {
                this.scan(tree);
            }
        }
    }

    @Override
    public void visitFileInput(FileInput fileInput) {
        this.scan(fileInput.statements());
    }

    @Override
    public void visitStatementList(StatementList statementList) {
        this.scan(statementList.statements());
    }

    @Override
    public void visitIfStatement(IfStatement pyIfStatementTree) {
        this.scan(pyIfStatementTree.condition());
        this.scan(pyIfStatementTree.body());
        this.scan(pyIfStatementTree.elifBranches());
        this.scan(pyIfStatementTree.elseBranch());
    }

    @Override
    public void visitElseClause(ElseClause pyElseClauseTree) {
        this.scan(pyElseClauseTree.body());
    }

    @Override
    public void visitExecStatement(ExecStatement pyExecStatementTree) {
        this.scan(pyExecStatementTree.expression());
        this.scan(pyExecStatementTree.globalsExpression());
        this.scan(pyExecStatementTree.localsExpression());
    }

    @Override
    public void visitAssertStatement(AssertStatement pyAssertStatementTree) {
        this.scan(pyAssertStatementTree.condition());
        this.scan(pyAssertStatementTree.message());
    }

    @Override
    public void visitDelStatement(DelStatement pyDelStatementTree) {
        this.scan(pyDelStatementTree.expressions());
    }

    @Override
    public void visitPassStatement(PassStatement pyPassStatementTree) {
    }

    @Override
    public void visitPrintStatement(PrintStatement pyPrintStatementTree) {
        this.scan(pyPrintStatementTree.expressions());
    }

    @Override
    public void visitReturnStatement(ReturnStatement pyReturnStatementTree) {
        this.scan(pyReturnStatementTree.expressions());
    }

    @Override
    public void visitYieldStatement(YieldStatement pyYieldStatementTree) {
        this.scan(pyYieldStatementTree.yieldExpression());
    }

    @Override
    public void visitYieldExpression(YieldExpression pyYieldExpressionTree) {
        this.scan(pyYieldExpressionTree.expressions());
    }

    @Override
    public void visitRaiseStatement(RaiseStatement pyRaiseStatementTree) {
        this.scan(pyRaiseStatementTree.expressions());
        this.scan(pyRaiseStatementTree.fromExpression());
    }

    @Override
    public void visitBreakStatement(BreakStatement pyBreakStatementTree) {
    }

    @Override
    public void visitContinueStatement(ContinueStatement pyContinueStatementTree) {
    }

    @Override
    public void visitFunctionDef(FunctionDef pyFunctionDefTree) {
        this.scan(pyFunctionDefTree.decorators());
        this.scan(pyFunctionDefTree.name());
        this.scan(pyFunctionDefTree.parameters());
        this.scan(pyFunctionDefTree.returnTypeAnnotation());
        this.scan(pyFunctionDefTree.body());
    }

    @Override
    public void visitName(Name pyNameTree) {
    }

    @Override
    public void visitClassDef(ClassDef pyClassDefTree) {
        this.scan(pyClassDefTree.name());
        this.scan(pyClassDefTree.args());
        this.scan(pyClassDefTree.body());
    }

    @Override
    public void visitAliasedName(AliasedName aliasedName) {
        this.scan(aliasedName.dottedName());
        this.scan(aliasedName.alias());
    }

    @Override
    public void visitDottedName(DottedName dottedName) {
        this.scan(dottedName.names());
    }

    @Override
    public void visitImportFrom(ImportFrom pyImportFromTree) {
        this.scan(pyImportFromTree.module());
        this.scan(pyImportFromTree.importedNames());
    }

    @Override
    public void visitForStatement(ForStatement pyForStatementTree) {
        this.scan(pyForStatementTree.expressions());
        this.scan(pyForStatementTree.testExpressions());
        this.scan(pyForStatementTree.body());
        this.scan(pyForStatementTree.elseClause());
    }

    @Override
    public void visitImportName(ImportName pyImportNameTree) {
        this.scan(pyImportNameTree.modules());
    }

    @Override
    public void visitGlobalStatement(GlobalStatement pyGlobalStatementTree) {
        this.scan(pyGlobalStatementTree.variables());
    }

    @Override
    public void visitNonlocalStatement(NonlocalStatement pyNonlocalStatementTree) {
        this.scan(pyNonlocalStatementTree.variables());
    }

    @Override
    public void visitWhileStatement(WhileStatement pyWhileStatementTree) {
        this.scan(pyWhileStatementTree.condition());
        this.scan(pyWhileStatementTree.body());
        this.scan(pyWhileStatementTree.elseClause());
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement pyExpressionStatementTree) {
        this.scan(pyExpressionStatementTree.expressions());
    }

    @Override
    public void visitTryStatement(TryStatement pyTryStatementTree) {
        this.scan(pyTryStatementTree.body());
        this.scan(pyTryStatementTree.exceptClauses());
        this.scan(pyTryStatementTree.finallyClause());
        this.scan(pyTryStatementTree.elseClause());
    }

    @Override
    public void visitFinallyClause(FinallyClause finallyClause) {
        this.scan(finallyClause.body());
    }

    @Override
    public void visitExceptClause(ExceptClause exceptClause) {
        this.scan(exceptClause.exception());
        this.scan(exceptClause.exceptionInstance());
        this.scan(exceptClause.body());
    }

    @Override
    public void visitWithStatement(WithStatement pyWithStatementTree) {
        this.scan(pyWithStatementTree.withItems());
        this.scan(pyWithStatementTree.statements());
    }

    @Override
    public void visitWithItem(WithItem withItem) {
        this.scan(withItem.test());
        this.scan(withItem.expression());
    }

    @Override
    public void visitQualifiedExpression(QualifiedExpression pyQualifiedExpressionTree) {
        this.scan(pyQualifiedExpressionTree.qualifier());
        this.scan(pyQualifiedExpressionTree.name());
    }

    @Override
    public void visitCallExpression(CallExpression pyCallExpressionTree) {
        this.scan(pyCallExpressionTree.callee());
        this.scan(pyCallExpressionTree.argumentList());
    }

    @Override
    public void visitArgumentList(ArgList argList) {
        this.scan(argList.arguments());
    }

    @Override
    public void visitRegularArgument(RegularArgument regularArgumentTree) {
        this.scan(regularArgumentTree.keywordArgument());
        this.scan(regularArgumentTree.expression());
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement pyAssignmentStatementTree) {
        this.scan(pyAssignmentStatementTree.lhsExpressions());
        this.scan(pyAssignmentStatementTree.assignedValue());
    }

    @Override
    public void visitExpressionList(ExpressionList pyExpressionListTree) {
        this.scan(pyExpressionListTree.expressions());
    }

    @Override
    public void visitBinaryExpression(BinaryExpression pyBinaryExpressionTree) {
        this.scan(pyBinaryExpressionTree.leftOperand());
        this.scan(pyBinaryExpressionTree.rightOperand());
    }

    @Override
    public void visitLambda(LambdaExpression pyLambdaExpressionTree) {
        this.scan(pyLambdaExpressionTree.parameters());
        this.scan(pyLambdaExpressionTree.expression());
    }

    @Override
    public void visitParameterList(ParameterList parameterList) {
        this.scan(parameterList.all());
    }

    @Override
    public void visitTupleParameter(TupleParameter tree) {
        this.scan(tree.parameters());
    }

    @Override
    public void visitParameter(Parameter tree) {
        this.scan(tree.name());
        this.scan(tree.typeAnnotation());
        this.scan(tree.defaultValue());
    }

    @Override
    public void visitTypeAnnotation(TypeAnnotation tree) {
        this.scan(tree.expression());
    }

    @Override
    public void visitNumericLiteral(NumericLiteral pyNumericLiteralTree) {
    }

    @Override
    public void visitStringLiteral(StringLiteral pyStringLiteralTree) {
        this.scan(pyStringLiteralTree.stringElements());
    }

    @Override
    public void visitStringElement(StringElement tree) {
        if (tree.isInterpolated()) {
            this.scan(tree.interpolatedExpressions());
        }
    }

    @Override
    public void visitListLiteral(ListLiteral pyListLiteralTree) {
        this.scan(pyListLiteralTree.elements());
    }

    @Override
    public void visitUnaryExpression(UnaryExpression pyUnaryExpressionTree) {
        this.scan(pyUnaryExpressionTree.expression());
    }

    @Override
    public void visitUnpackingExpression(UnpackingExpression unpackingExpressionTree) {
        this.scan(unpackingExpressionTree.expression());
    }

    @Override
    public void visitAwaitExpression(AwaitExpression pyAwaitExpressionTree) {
        this.scan(pyAwaitExpressionTree.expression());
    }

    @Override
    public void visitSliceExpression(SliceExpression pySliceExpressionTree) {
        this.scan(pySliceExpressionTree.object());
        this.scan(pySliceExpressionTree.sliceList());
    }

    @Override
    public void visitSliceList(SliceList sliceList) {
        this.scan(sliceList.slices());
    }

    @Override
    public void visitSliceItem(SliceItem sliceItem) {
        this.scan(sliceItem.lowerBound());
        this.scan(sliceItem.upperBound());
        this.scan(sliceItem.stride());
    }

    @Override
    public void visitSubscriptionExpression(SubscriptionExpression pySubscriptionExpressionTree) {
        this.scan(pySubscriptionExpressionTree.object());
        this.scan(pySubscriptionExpressionTree.subscripts());
    }

    @Override
    public void visitParenthesizedExpression(ParenthesizedExpression pyParenthesizedExpressionTree) {
        this.scan(pyParenthesizedExpressionTree.expression());
    }

    @Override
    public void visitTuple(Tuple pyTupleTree) {
        this.scan(pyTupleTree.elements());
    }

    @Override
    public void visitConditionalExpression(ConditionalExpression pyConditionalExpressionTree) {
        this.scan(pyConditionalExpressionTree.condition());
        this.scan(pyConditionalExpressionTree.trueExpression());
        this.scan(pyConditionalExpressionTree.falseExpression());
    }

    @Override
    public void visitPyListOrSetCompExpression(ComprehensionExpression tree) {
        this.scan(tree.resultExpression());
        this.scan(tree.comprehensionFor());
    }

    @Override
    public void visitComprehensionFor(ComprehensionFor tree) {
        this.scan(tree.loopExpression());
        this.scan(tree.iterable());
        this.scan(tree.nestedClause());
    }

    @Override
    public void visitComprehensionIf(ComprehensionIf tree) {
        this.scan(tree.condition());
        this.scan(tree.nestedClause());
    }

    @Override
    public void visitDictionaryLiteral(DictionaryLiteral pyDictionaryLiteralTree) {
        this.scan(pyDictionaryLiteralTree.elements());
    }

    @Override
    public void visitSetLiteral(SetLiteral pySetLiteralTree) {
        this.scan(pySetLiteralTree.elements());
    }

    @Override
    public void visitKeyValuePair(KeyValuePair keyValuePair) {
        this.scan(keyValuePair.key());
        this.scan(keyValuePair.value());
    }

    @Override
    public void visitDictCompExpression(DictCompExpressionImpl tree) {
        this.scan(tree.keyExpression());
        this.scan(tree.valueExpression());
        this.scan(tree.comprehensionFor());
    }

    @Override
    public void visitCompoundAssignment(CompoundAssignmentStatement pyCompoundAssignmentStatementTree) {
        this.scan(pyCompoundAssignmentStatementTree.lhsExpression());
        this.scan(pyCompoundAssignmentStatementTree.rhsExpression());
    }

    @Override
    public void visitAnnotatedAssignment(AnnotatedAssignment annotatedAssignment) {
        this.scan(annotatedAssignment.variable());
        this.scan(annotatedAssignment.annotation());
        this.scan(annotatedAssignment.assignedValue());
    }

    @Override
    public void visitNone(NoneExpression pyNoneExpressionTree) {
    }

    @Override
    public void visitRepr(ReprExpression pyReprExpressionTree) {
        this.scan(pyReprExpressionTree.expressionList());
    }

    @Override
    public void visitEllipsis(EllipsisExpression pyEllipsisExpressionTree) {
    }

    @Override
    public void visitDecorator(Decorator decorator) {
        this.scan(decorator.name());
        this.scan(decorator.arguments());
    }

    @Override
    public void visitToken(Token token) {
    }
}

