/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python;

import com.sonar.sslr.api.AstNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.sonar.plugins.python.api.PythonCheck;
import org.sonar.plugins.python.api.PythonVisitorContext;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.python.PythonFile;
import org.sonar.python.parser.PythonParser;
import org.sonar.python.tree.PythonTreeMaker;

public class TestPythonVisitorRunner {
    private TestPythonVisitorRunner() {
    }

    public static PythonVisitorContext scanFile(File file, PythonCheck ... visitors) {
        PythonVisitorContext context = TestPythonVisitorRunner.createContext(file);
        for (PythonCheck visitor : visitors) {
            visitor.scanFile(context);
        }
        return context;
    }

    public static PythonVisitorContext createContext(File file) {
        PythonParser parser = PythonParser.create();
        TestPythonFile pythonFile = new TestPythonFile(file);
        AstNode astNode = parser.parse(pythonFile.content());
        FileInput rootTree = new PythonTreeMaker().fileInput(astNode);
        return new PythonVisitorContext(rootTree, pythonFile);
    }

    private static class TestPythonFile
    implements PythonFile {
        private final File file;

        public TestPythonFile(File file) {
            this.file = file;
        }

        @Override
        public String content() {
            try {
                return new String(Files.readAllBytes(this.file.toPath()), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read " + this.file, e);
            }
        }

        @Override
        public String fileName() {
            return this.file.getName();
        }
    }
}

