/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.tree;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.plugins.python.api.tree.FileInput;
import org.sonar.plugins.python.api.tree.StatementList;
import org.sonar.plugins.python.api.tree.StringLiteral;
import org.sonar.plugins.python.api.tree.Token;
import org.sonar.plugins.python.api.tree.Tree;
import org.sonar.plugins.python.api.tree.TreeVisitor;
import org.sonar.python.semantic.Symbol;
import org.sonar.python.tree.PyTree;

public class FileInputImpl
extends PyTree
implements FileInput {
    private final StatementList statements;
    private final Token endOfFile;
    private final StringLiteral docstring;
    private final Set<Symbol> globalVariables = new HashSet<Symbol>();

    public FileInputImpl(@Nullable StatementList statements, Token endOfFile, @Nullable StringLiteral docstring) {
        this.statements = statements;
        this.endOfFile = endOfFile;
        this.docstring = docstring;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.FILE_INPUT;
    }

    @Override
    @CheckForNull
    public StatementList statements() {
        return this.statements;
    }

    @Override
    @CheckForNull
    public StringLiteral docstring() {
        return this.docstring;
    }

    @Override
    public Set<Symbol> globalVariables() {
        return this.globalVariables;
    }

    public void addGlobalVariables(Symbol globalVariable) {
        this.globalVariables.add(globalVariable);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitFileInput(this);
    }

    @Override
    public List<Tree> computeChildren() {
        return Stream.of(this.statements, this.endOfFile).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

